/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.ArrayList;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeError;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class GroupQueryNode
extends QueryNodeImpl {
    private static final long serialVersionUID = -9204673493869114999L;

    public GroupQueryNode(QueryNode query) {
        if (query == null) {
            throw new QueryNodeError((Message)new MessageImpl(QueryParserMessages.PARAMETER_VALUE_NOT_SUPPORTED, new Object[]{"query", "null"}));
        }
        this.allocate();
        this.setLeaf(false);
        this.add(query);
    }

    public QueryNode getChild() {
        return this.getChildren().get(0);
    }

    public String toString() {
        return "<group>\n" + ((Object)this.getChild()).toString() + "\n</group>";
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChild() == null) {
            return "";
        }
        return "( " + this.getChild().toQueryString(escapeSyntaxParser) + " )";
    }

    public QueryNode cloneTree() throws CloneNotSupportedException {
        GroupQueryNode clone = (GroupQueryNode)super.cloneTree();
        return clone;
    }

    public void setChild(QueryNode child) {
        ArrayList<QueryNode> list = new ArrayList<QueryNode>();
        list.add(child);
        this.set(list);
    }
}

