/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch.model;

import org.apache.abdera.Abdera;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;

public class Query
extends ExtensibleElementWrapper {
    public Query(Factory factory) {
        super(factory, OpenSearchConstants.QUERY);
    }

    public Query(Abdera abdera) {
        this(abdera.getFactory());
    }

    public Query(Element internal) {
        super(internal);
    }

    public Role getRole() {
        String role = this.getAttributeValue("role");
        if (role == null) {
            return null;
        }
        try {
            return Role.valueOf(role.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setRole(Role role) {
        if (role != null) {
            this.setAttributeValue("role", role.name().toLowerCase());
        } else {
            this.removeAttribute("role");
        }
    }

    public String getTitle() {
        return this.getAttributeValue("title");
    }

    public void setTitle(String title) {
        if (title != null) {
            if (title.length() > 256) {
                throw new IllegalArgumentException("Title too long (max 256 characters)");
            }
            this.setAttributeValue("title", title);
        } else {
            this.removeAttribute("title");
        }
    }

    public int getTotalResults() {
        String val = this.getAttributeValue("totalResult");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setTotalResults(int totalResults) {
        if (totalResults > -1) {
            this.setAttributeValue("totalResult", String.valueOf(totalResults));
        } else {
            this.removeAttribute("totalResult");
        }
    }

    public String getSearchTerms() {
        return this.getAttributeValue("searchTerms");
    }

    public void setSearchTerms(String terms) {
        if (terms != null) {
            this.setAttributeValue("searchTerms", terms);
        } else {
            this.removeAttribute("searchTerms");
        }
    }

    public int getCount() {
        String val = this.getAttributeValue("count");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setCount(int count) {
        if (count > -1) {
            this.setAttributeValue("count", String.valueOf(count));
        } else {
            this.removeAttribute("count");
        }
    }

    public int getStartIndex() {
        String val = this.getAttributeValue("startIndex");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setStartIndex(int startIndex) {
        if (startIndex > -1) {
            this.setAttributeValue("startIndex", String.valueOf(startIndex));
        } else {
            this.removeAttribute("startIndex");
        }
    }

    public int getStartPage() {
        String val = this.getAttributeValue("startPage");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setStartPage(int startPage) {
        if (startPage > -1) {
            this.setAttributeValue("startPage", String.valueOf(startPage));
        } else {
            this.removeAttribute("startPage");
        }
    }

    public String getResultsLanguage() {
        return this.getAttributeValue("language");
    }

    public void setResultsLanguage(String language) {
        if (language != null) {
            this.setAttributeValue("language", language);
        } else {
            this.removeAttribute("language");
        }
    }

    public String getInputEncoding() {
        return this.getAttributeValue("inputEncoding");
    }

    public void setInputEncoding(String encoding) {
        if (encoding != null) {
            this.setAttributeValue("inputEncoding", encoding);
        } else {
            this.removeAttribute("inputEncoding");
        }
    }

    public String getOutputEncoding() {
        return this.getAttributeValue("outputEncoding");
    }

    public void setOutputEncoding(String encoding) {
        if (encoding != null) {
            this.setAttributeValue("outputEncoding", encoding);
        } else {
            this.removeAttribute("outputEncoding");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        CORRECTION,
        EXAMPLE,
        RELATED,
        REQUEST,
        SUBSET,
        SUPERSET;

    }
}

