/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsetprototypes.lar;

import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class LayoutSetPrototypeStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutSetPrototype> {
    public static final String[] CLASS_NAMES = new String[]{LayoutSetPrototype.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototypeByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (layoutSetPrototype != null) {
            LayoutSetPrototypeLocalServiceUtil.deleteLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutSetPrototype layoutSetPrototype) throws Exception {
        Element layoutSetPrototypeElement = portletDataContext.getExportDataElement((ClassedModel)layoutSetPrototype);
        portletDataContext.addClassedModel(layoutSetPrototypeElement, ExportImportPathUtil.getModelPath((StagedModel)layoutSetPrototype), (ClassedModel)layoutSetPrototype);
        this.exportLayouts(layoutSetPrototype, portletDataContext);
        this.exportLayoutPrototypes(portletDataContext, layoutSetPrototype, layoutSetPrototypeElement);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutSetPrototype layoutSetPrototype) throws Exception {
        long userId = portletDataContext.getUserId(layoutSetPrototype.getUserUuid());
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        boolean layoutsUpdateable = GetterUtil.getBoolean((String)settingsProperties.getProperty("layoutsUpdateable"), (boolean)true);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutSetPrototype);
        serviceContext.setAttribute("addDefaultLayout", (Serializable)Boolean.valueOf(false));
        LayoutSetPrototype importedLayoutSetPrototype = null;
        if (portletDataContext.isDataStrategyMirror()) {
            LayoutSetPrototype existingLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototype.getUuid(), (long)portletDataContext.getCompanyId());
            if (existingLayoutSetPrototype == null) {
                serviceContext.setUuid(layoutSetPrototype.getUuid());
                importedLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutSetPrototype.getNameMap(), (String)layoutSetPrototype.getDescription(), (boolean)layoutSetPrototype.isActive(), (boolean)layoutsUpdateable, (ServiceContext)serviceContext);
            } else {
                importedLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((long)existingLayoutSetPrototype.getLayoutSetPrototypeId(), (Map)layoutSetPrototype.getNameMap(), (String)layoutSetPrototype.getDescription(), (boolean)layoutSetPrototype.isActive(), (boolean)layoutsUpdateable, (ServiceContext)serviceContext);
            }
        } else {
            importedLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutSetPrototype.getNameMap(), (String)layoutSetPrototype.getDescription(), (boolean)layoutSetPrototype.isActive(), (boolean)layoutsUpdateable, (ServiceContext)serviceContext);
        }
        this.importLayoutPrototypes(portletDataContext, layoutSetPrototype);
        this.importLayouts(portletDataContext, layoutSetPrototype, importedLayoutSetPrototype, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)layoutSetPrototype, (ClassedModel)importedLayoutSetPrototype);
    }

    protected void exportLayoutPrototypes(PortletDataContext portletDataContext, LayoutSetPrototype layoutSetPrototype, Element layoutSetPrototypeElement) throws Exception {
        DynamicQuery dynamicQuery = LayoutLocalServiceUtil.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)layoutSetPrototype.getGroupId()));
        Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
        Property layoutPrototypeUuidProperty = PropertyFactoryUtil.forName((String)"layoutPrototypeUuid");
        conjunction.add(layoutPrototypeUuidProperty.isNotNull());
        conjunction.add(layoutPrototypeUuidProperty.ne((Object)""));
        dynamicQuery.add((Criterion)conjunction);
        List layouts = LayoutLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        boolean exportLayoutPrototypes = portletDataContext.getBooleanParameter("layout_set_prototypes", "page-templates");
        for (Layout layout : layouts) {
            String layoutPrototypeUuid = layout.getLayoutPrototypeUuid();
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)portletDataContext.getCompanyId());
            portletDataContext.addReferenceElement((ClassedModel)layout, layoutSetPrototypeElement, (ClassedModel)layoutPrototype, "dependency", !exportLayoutPrototypes);
            if (!exportLayoutPrototypes) continue;
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPrototype);
        }
    }

    protected void exportLayouts(LayoutSetPrototype layoutSetPrototype, PortletDataContext portletDataContext) throws Exception {
        File file = null;
        FileInputStream inputStream = null;
        try {
            file = SitesUtil.exportLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype, (ServiceContext)new ServiceContext());
            inputStream = new FileInputStream(file);
            String layoutSetPrototypeLARPath = ExportImportPathUtil.getModelPath((StagedModel)layoutSetPrototype, (String)this.getLayoutSetPrototypeLARFileName(layoutSetPrototype));
            if (portletDataContext.isPathNotProcessed(layoutSetPrototypeLARPath)) {
                portletDataContext.addZipEntry(layoutSetPrototypeLARPath, (InputStream)inputStream);
            }
            List layoutSetPrototypeLayouts = LayoutLocalServiceUtil.getLayouts((long)layoutSetPrototype.getGroupId(), (boolean)true);
            Element layoutSetPrototypeElement = portletDataContext.getExportDataElement((ClassedModel)layoutSetPrototype);
            for (Layout layoutSetPrototypeLayout : layoutSetPrototypeLayouts) {
                portletDataContext.addReferenceElement((ClassedModel)layoutSetPrototype, layoutSetPrototypeElement, (ClassedModel)layoutSetPrototypeLayout, "embedded", false);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(inputStream);
            if (file != null) {
                file.delete();
            }
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream);
        if (file != null) {
            file.delete();
        }
    }

    protected String getLayoutSetPrototypeLARFileName(LayoutSetPrototype layoutSetPrototype) {
        return String.valueOf(layoutSetPrototype.getLayoutSetPrototypeId()) + ".lar";
    }

    protected void importLayoutPrototypes(PortletDataContext portletDataContext, LayoutSetPrototype layoutSetPrototype) throws PortletDataException {
        List layoutPrototypeElements = portletDataContext.getReferenceDataElements((StagedModel)layoutSetPrototype, LayoutPrototype.class);
        for (Element layoutPrototypeElement : layoutPrototypeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutPrototypeElement);
        }
    }

    protected void importLayouts(PortletDataContext portletDataContext, LayoutSetPrototype layoutSetPrototype, LayoutSetPrototype importedLayoutSetPrototype, ServiceContext serviceContext) throws PortalException, SystemException {
        InputStream inputStream = null;
        try {
            String layoutSetPrototypeLARPath = ExportImportPathUtil.getModelPath((StagedModel)layoutSetPrototype, (String)this.getLayoutSetPrototypeLARFileName(layoutSetPrototype));
            inputStream = portletDataContext.getZipEntryAsInputStream(layoutSetPrototypeLARPath);
            SitesUtil.importLayoutSetPrototype((LayoutSetPrototype)importedLayoutSetPrototype, (InputStream)inputStream, (ServiceContext)serviceContext);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(inputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream);
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototypeByUuidAndCompanyId((String)uuid, (long)companyId);
        return layoutSetPrototype != null;
    }
}

