/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import java.util.Locale;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class LayoutRevisionAssetRenderer
extends BaseAssetRenderer {
    private LayoutBranch _layoutBranch;
    private LayoutRevision _layoutRevision;
    private LayoutSetBranch _layoutSetBranch;

    public LayoutRevisionAssetRenderer(LayoutRevision layoutRevision) {
        this._layoutRevision = layoutRevision;
        try {
            this._layoutBranch = layoutRevision.getLayoutBranch();
            this._layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)this._layoutRevision.getLayoutSetBranchId());
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public String getClassName() {
        return LayoutRevision.class.getName();
    }

    public long getClassPK() {
        return this._layoutRevision.getLayoutRevisionId();
    }

    public long getGroupId() {
        return this._layoutRevision.getGroupId();
    }

    public String getSummary(Locale locale) {
        StringBundler sb = new StringBundler(16);
        sb.append("<strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"page"));
        sb.append(":</strong> ");
        sb.append(this._layoutRevision.getHTMLTitle(locale));
        sb.append("<br /><strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"site-pages-variation"));
        sb.append(":</strong> ");
        sb.append(LanguageUtil.get((Locale)locale, (String)this._layoutSetBranch.getName()));
        sb.append("<br /><strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"page-variation"));
        sb.append(":</strong> ");
        sb.append(LanguageUtil.get((Locale)locale, (String)this._layoutBranch.getName()));
        sb.append("<br /><strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"revision-id"));
        sb.append(":</strong> ");
        sb.append(this._layoutRevision.getLayoutRevisionId());
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        return this._layoutRevision.getHTMLTitle(locale);
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)this._layoutRevision.getPlid());
            String layoutURL = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"layoutSetBranchId", (long)this._layoutRevision.getLayoutSetBranchId());
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"layoutRevisionId", (long)this._layoutRevision.getLayoutRevisionId());
            return layoutURL;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public long getUserId() {
        return this._layoutRevision.getUserId();
    }

    public String getUserName() {
        return this._layoutRevision.getUserName();
    }

    public String getUuid() {
        return null;
    }

    public boolean isPreviewInContext() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("LAYOUT_REVISION", (Object)this._layoutRevision);
            return "/html/portlet/layouts_admin/asset/" + template + ".jsp";
        }
        return null;
    }
}

