/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jcr;

import com.liferay.portal.jcr.JCRFactory;
import com.liferay.portal.jcr.JCRSessionInvocationHandler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JCRFactoryUtil {
    private static JCRFactory _jcrFactory;
    private static ThreadLocal<Map<String, Session>> _sessions;

    static {
        _sessions = new AutoResetThreadLocal(JCRFactoryUtil.class + "._sessions", new HashMap());
    }

    public static void closeSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public static Session createSession() throws RepositoryException {
        return JCRFactoryUtil.createSession(null);
    }

    public static Session createSession(String workspaceName) throws RepositoryException {
        if (workspaceName == null) {
            workspaceName = JCRFactory.WORKSPACE_NAME;
        }
        if (!PropsValues.JCR_WRAP_SESSION) {
            JCRFactory jcrFactory = JCRFactoryUtil.getJCRFactory();
            return jcrFactory.createSession(workspaceName);
        }
        Map<String, Session> sessions = _sessions.get();
        Session session = sessions.get(workspaceName);
        if (session != null) {
            return session;
        }
        JCRFactory jcrFactory = JCRFactoryUtil.getJCRFactory();
        Session jcrSession = jcrFactory.createSession(workspaceName);
        JCRSessionInvocationHandler jcrSessionInvocationHandler = new JCRSessionInvocationHandler(jcrSession);
        Object sessionProxy = ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{Map.class, Session.class}, (InvocationHandler)jcrSessionInvocationHandler);
        FinalizeManager.register((Object)sessionProxy, (FinalizeAction)jcrSessionInvocationHandler);
        session = (Session)sessionProxy;
        sessions.put(workspaceName, session);
        return session;
    }

    public static JCRFactory getJCRFactory() {
        if (_jcrFactory == null) {
            _jcrFactory = (JCRFactory)PortalBeanLocatorUtil.locate((String)JCRFactory.class.getName());
        }
        return _jcrFactory;
    }

    public static void initialize() throws RepositoryException {
        JCRFactory jcrFactory = JCRFactoryUtil.getJCRFactory();
        jcrFactory.initialize();
    }

    public static void prepare() throws RepositoryException {
        JCRFactory jcrFactory = JCRFactoryUtil.getJCRFactory();
        jcrFactory.prepare();
    }

    public static void shutdown() {
        JCRFactory jcrFactory = JCRFactoryUtil.getJCRFactory();
        jcrFactory.shutdown();
    }
}

