/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserNotificationEventLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserNotificationEventLocalServiceImpl
extends UserNotificationEventLocalServiceBaseImpl {
    public UserNotificationEvent addUserNotificationEvent(long userId, NotificationEvent notificationEvent) throws PortalException, SystemException {
        JSONObject payloadJSONObject = notificationEvent.getPayload();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUuid(notificationEvent.getUuid());
        return this.addUserNotificationEvent(userId, notificationEvent.getType(), notificationEvent.getTimestamp(), notificationEvent.getDeliverBy(), payloadJSONObject.toString(), notificationEvent.isArchived(), serviceContext);
    }

    public UserNotificationEvent addUserNotificationEvent(long userId, String type, long timestamp, long deliverBy, String payload, boolean archived, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long userNotificationEventId = this.counterLocalService.increment();
        UserNotificationEvent userNotificationEvent = this.userNotificationEventPersistence.create(userNotificationEventId);
        userNotificationEvent.setUuid(serviceContext.getUuid());
        userNotificationEvent.setCompanyId(user.getCompanyId());
        userNotificationEvent.setUserId(userId);
        userNotificationEvent.setType(type);
        userNotificationEvent.setTimestamp(timestamp);
        userNotificationEvent.setDeliverBy(deliverBy);
        userNotificationEvent.setDelivered(false);
        userNotificationEvent.setPayload(payload);
        userNotificationEvent.setArchived(archived);
        this.userNotificationEventPersistence.update((BaseModel)userNotificationEvent);
        return userNotificationEvent;
    }

    public List<UserNotificationEvent> addUserNotificationEvents(long userId, Collection<NotificationEvent> notificationEvents) throws PortalException, SystemException {
        ArrayList<UserNotificationEvent> userNotificationEvents = new ArrayList<UserNotificationEvent>(notificationEvents.size());
        for (NotificationEvent notificationEvent : notificationEvents) {
            UserNotificationEvent userNotificationEvent = this.addUserNotificationEvent(userId, notificationEvent);
            userNotificationEvents.add(userNotificationEvent);
        }
        return userNotificationEvents;
    }

    public void deleteUserNotificationEvent(String uuid, long companyId) throws SystemException {
        this.userNotificationEventPersistence.removeByUuid_C(uuid, companyId);
    }

    public void deleteUserNotificationEvents(Collection<String> uuids, long companyId) throws SystemException {
        for (String uuid : uuids) {
            this.deleteUserNotificationEvent(uuid, companyId);
        }
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean archived) throws SystemException {
        return this.userNotificationEventPersistence.findByU_A(userId, archived);
    }

    public List<UserNotificationEvent> getArchivedUserNotificationEvents(long userId, boolean archived, int start, int end) throws SystemException {
        return this.userNotificationEventPersistence.findByU_A(userId, archived, start, end);
    }

    public int getArchivedUserNotificationEventsCount(long userId, boolean archived) throws SystemException {
        return this.userNotificationEventPersistence.countByU_A(userId, archived);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered) throws SystemException {
        return this.userNotificationEventPersistence.findByU_D(userId, delivered);
    }

    public List<UserNotificationEvent> getDeliveredUserNotificationEvents(long userId, boolean delivered, int start, int end) throws SystemException {
        return this.userNotificationEventPersistence.findByU_D(userId, delivered, start, end);
    }

    public int getDeliveredUserNotificationEventsCount(long userId, boolean delivered) throws SystemException {
        return this.userNotificationEventPersistence.countByU_D(userId, delivered);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId) throws SystemException {
        return this.userNotificationEventPersistence.findByUserId(userId);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, boolean archived) throws SystemException {
        return this.getArchivedUserNotificationEvents(userId, archived);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, boolean archived, int start, int end) throws SystemException {
        return this.getArchivedUserNotificationEvents(userId, archived, start, end);
    }

    public List<UserNotificationEvent> getUserNotificationEvents(long userId, int start, int end) throws SystemException {
        return this.userNotificationEventPersistence.findByUserId(userId, start, end);
    }

    public int getUserNotificationEventsCount(long userId) throws SystemException {
        return this.userNotificationEventPersistence.countByUserId(userId);
    }

    public int getUserNotificationEventsCount(long userId, boolean archived) throws SystemException {
        return this.getArchivedUserNotificationEventsCount(userId, archived);
    }

    public UserNotificationEvent updateUserNotificationEvent(String uuid, long companyId, boolean archive) throws SystemException {
        List userNotificationEvents = this.userNotificationEventPersistence.findByUuid_C(uuid, companyId);
        if (userNotificationEvents.isEmpty()) {
            return null;
        }
        UserNotificationEvent userNotificationEvent = (UserNotificationEvent)userNotificationEvents.get(0);
        userNotificationEvent.setArchived(archive);
        this.userNotificationEventPersistence.update((BaseModel)userNotificationEvent);
        return userNotificationEvent;
    }

    public List<UserNotificationEvent> updateUserNotificationEvents(Collection<String> uuids, long companyId, boolean archive) throws SystemException {
        ArrayList<UserNotificationEvent> userNotificationEvents = new ArrayList<UserNotificationEvent>();
        for (String uuid : uuids) {
            userNotificationEvents.add(this.updateUserNotificationEvent(uuid, companyId, archive));
        }
        return userNotificationEvents;
    }
}

