/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.main.bnd;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Tree;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import aQute.lib.collections.SortedList;
import aQute.lib.getopt.Arguments;
import aQute.lib.getopt.Description;
import aQute.lib.getopt.Options;
import aQute.lib.tag.Tag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class BaselineCommands {
    static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    final bnd bnd;
    final Baseline baseline;
    final DiffPluginImpl differ = new DiffPluginImpl();
    final Collection<String> SKIP_HEADERS = Arrays.asList("Created-By", "Bnd-LastModified", "Bundle-ManifestVersion", "Manifest-Version", "Tool");

    BaselineCommands(bnd bnd2) throws IOException {
        this.bnd = bnd2;
        this.baseline = new Baseline(bnd2, this.differ);
    }

    @Description(value="Compare a newer bundle to a baselined bundle and provide versioning advice")
    public void _baseline(baseLineOptions opts) throws Exception {
        File newer;
        Project project;
        List<String> args = opts._();
        if (args.size() == 0 && (project = this.bnd.getProject()) != null) {
            ProjectBuilder pb = project.getBuilder(null);
            project.baseline();
            this.bnd.getInfo(project);
            return;
        }
        if (args.size() != 2) {
            throw new IllegalArgumentException("Accepts only two argument (<jar>)");
        }
        PrintStream out = null;
        if (opts.fixup() != null) {
            out = new PrintStream(this.bnd.getFile(opts.fixup()), "UTF-8");
        }
        if (!(newer = this.bnd.getFile(args.get(0))).isFile()) {
            throw new IllegalArgumentException("Not a valid newer input file: " + newer);
        }
        File older = this.bnd.getFile(args.get(1));
        if (!older.isFile()) {
            throw new IllegalArgumentException("Not a valid older input file: " + older);
        }
        Jar nj = new Jar(newer);
        Jar oj = new Jar(older);
        Set<Baseline.Info> infos = this.baseline.baseline(nj, oj, null);
        Baseline.Info[] sorted = infos.toArray(new Baseline.Info[infos.size()]);
        Arrays.sort(sorted, new Comparator<Baseline.Info>(){

            @Override
            public int compare(Baseline.Info o1, Baseline.Info o2) {
                return o1.packageName.compareTo(o2.packageName);
            }
        });
        this.bnd.out.printf("  %-50s %-10s %-10s %-10s %-10s %-10s%n", "Package", "Delta", "New", "Old", "Suggest", "If Prov.");
        for (Baseline.Info info : sorted) {
            this.bnd.out.printf("%s %-50s %-10s %-10s %-10s %-10s %-10s%n", new Object[]{Character.valueOf(info.mismatch ? (char)'*' : ' '), info.packageName, info.packageDiff.getDelta(), info.newerVersion, info.olderVersion, info.suggestedVersion, info.suggestedIfProviders == null ? "-" : info.suggestedIfProviders});
        }
        if (out != null) {
            Manifest manifest = nj.getManifest();
            if (manifest == null) {
                manifest = new Manifest();
            }
            for (Map.Entry<Object, Object> e : manifest.getMainAttributes().entrySet()) {
                String key = e.getKey().toString();
                if (this.SKIP_HEADERS.contains(key)) continue;
                if (!"Export-Package".equals(key)) {
                    out.printf("%-40s = ", key);
                    String value = (String)e.getValue();
                    out.append(value);
                }
                out.println();
            }
            this.doExportPackage(sorted, out);
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _schema(schemaOptions opts) throws Exception {
        MultiMap<String, PSpec> map = new MultiMap<String, PSpec>();
        Tag top = new Tag("jschema", new Object[0]);
        int n = 1000;
        for (String spec : opts._()) {
            File f = this.bnd.getFile(spec);
            if (!f.isFile()) {
                this.bnd.messages.NoSuchFile_(f);
                continue;
            }
            this.bnd.trace("spec %s", f);
            Jar jar = new Jar(f);
            Manifest m = jar.getManifest();
            Attributes main = m.getMainAttributes();
            Tag specTag = new Tag(top, "specification", new Object[0]);
            specTag.addAttribute("jar", spec);
            specTag.addAttribute("name", main.getValue("Specification-Name"));
            specTag.addAttribute("title", main.getValue("Specification-Title"));
            specTag.addAttribute("jsr", main.getValue("Specification-JSR"));
            specTag.addAttribute("url", main.getValue("Specification-URL"));
            specTag.addAttribute("version", main.getValue("Specification-Version"));
            specTag.addAttribute("vendor", main.getValue("Specification-Vendor"));
            specTag.addAttribute("id", n);
            specTag.addContent(main.getValue("Bundle-Description"));
            Parameters exports = OSGiHeader.parseHeader(m.getMainAttributes().getValue("Export-Package"));
            Parameters versions = new Parameters();
            versions.putAll(exports);
            versions.putAll(OSGiHeader.parseHeader(m.getMainAttributes().getValue("Import-Package")));
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.analyze();
            Tree tree = this.differ.tree(analyzer);
            for (Map.Entry<String, Attrs> entry : exports.entrySet()) {
                Attrs attrs = entry.getValue();
                String packageName = entry.getKey();
                Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
                String version = attrs.get("version");
                PSpec pspec = new PSpec();
                pspec.packageName = packageName;
                pspec.version = new Version(version);
                pspec.id = n;
                pspec.attrs = attrs;
                pspec.tree = tree;
                Collection uses = analyzer.getUses().get(packageRef);
                if (uses != null) {
                    for (Descriptors.PackageRef x : uses) {
                        String imp;
                        if (x.isJava() || (imp = x.getFQN()).equals(packageName)) continue;
                        String v = null;
                        if (versions.containsKey(imp)) {
                            v = versions.get(imp).get("version");
                        }
                        pspec.uses.put(imp, v);
                    }
                }
                map.add(packageName, pspec);
            }
            jar.close();
            ++n;
        }
        SortedList names = new SortedList(map.keySet());
        Tag packagesTag = new Tag(top, "packages", new Object[0]);
        Tag baselineTag = new Tag(top, "baseline", new Object[0]);
        for (String pname : names) {
            SortedList specs = new SortedList((Collection)map.get(pname));
            PSpec older = null;
            Parameters olderExport = null;
            for (PSpec newer : specs) {
                Tag pack = new Tag(packagesTag, "package", new Object[0]);
                pack.addAttribute("name", newer.packageName);
                pack.addAttribute("version", newer.version);
                pack.addAttribute("spec", newer.id);
                Parameters newerExport = new Parameters();
                newerExport.put(pname, newer.attrs);
                if (older != null) {
                    String compareId = newer.packageName + "-" + newer.id + "-" + older.id;
                    pack.addAttribute("delta", compareId);
                    this.bnd.trace(" newer=%s older=%s", newerExport, olderExport);
                    Set<Baseline.Info> infos = this.baseline.baseline(newer.tree, newerExport, older.tree, olderExport, new Instructions(pname));
                    for (Baseline.Info info : infos) {
                        Tag tag = this.getTag(info);
                        tag.addAttribute("id", compareId);
                        tag.addAttribute("newerSpec", newer.id);
                        tag.addAttribute("olderSpec", older.id);
                        baselineTag.addContent(tag);
                    }
                    older.tree = null;
                    older.attrs = null;
                    older = newer;
                }
                for (Map.Entry<String, String> uses : newer.uses.entrySet()) {
                    Tag reference = new Tag(pack, "import", new Object[0]);
                    reference.addAttribute("name", uses.getKey());
                    reference.addAttribute("version", uses.getValue());
                }
                older = newer;
                olderExport = newerExport;
            }
        }
        String o = opts.output("schema.xml");
        File of = this.bnd.getFile(o);
        File pof = of.getParentFile();
        if (!pof.exists() && !pof.mkdirs()) {
            throw new IOException("Could not create directory " + pof);
        }
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(of), "UTF-8");
        try {
            PrintWriter pw = new PrintWriter(fw);
            try {
                pw.println("<?xml version='1.0'?>");
                top.print(0, pw);
            }
            finally {
                pw.close();
            }
        }
        finally {
            fw.close();
        }
        if (opts.xsl() != null) {
            URL home = this.bnd.getBase().toURI().toURL();
            URL xslt = new URL(home, opts.xsl());
            String path = of.getAbsolutePath();
            if (path.endsWith(".xml")) {
                path = path.substring(0, path.length() - 4);
            }
            path = path + ".html";
            File html = new File(path);
            this.bnd.trace("xslt %s %s %s %s", xslt, of, html, html.exists());
            FileOutputStream out = new FileOutputStream(html);
            try {
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(xslt.openStream()));
                transformer.transform(new StreamSource(of), new StreamResult(out));
            }
            finally {
                out.close();
            }
        }
    }

    private Tag getTag(Baseline.Info info) {
        Tag tag = new Tag("info", new Object[0]);
        tag.addAttribute("name", info.packageName);
        tag.addAttribute("newerVersion", info.newerVersion);
        tag.addAttribute("olderVersion", info.olderVersion);
        tag.addAttribute("suggestedVersion", info.suggestedVersion);
        tag.addAttribute("suggestedIfProviders", info.suggestedIfProviders);
        tag.addAttribute("mismatch", info.mismatch);
        tag.addAttribute("warning", info.warning);
        StringBuilder sb = new StringBuilder();
        if (info.packageDiff.getDelta() == Delta.UNCHANGED) {
            tag.addAttribute("equals", "true");
        } else {
            this.traverseTag(sb, info.packageDiff, "");
            String s = sb.toString().trim();
            if (s.length() != 0) {
                Tag d = new Tag(tag, "diff", s);
                d.setCDATA();
            }
        }
        if (info.providers != null) {
            for (String provider : info.providers) {
                Tag p = new Tag(tag, "provider", new Object[0]);
                p.addAttribute("provider", provider);
            }
        }
        return tag;
    }

    private void traverseTag(StringBuilder sb, Diff diff, String indent) {
        sb.append(indent);
        sb.append(diff.toString().trim().replace('\n', ' '));
        sb.append("\n");
        if (diff.getDelta() == Delta.ADDED || diff.getDelta() == Delta.REMOVED) {
            return;
        }
        for (Diff diff2 : diff.getChildren()) {
            if (diff2.getDelta() == Delta.UNCHANGED || diff2.getDelta() == Delta.IGNORED) continue;
            this.traverseTag(sb, diff2, indent + " ");
        }
    }

    public void doExportPackage(Baseline.Info[] infos, PrintStream out) throws IOException {
        out.printf("# Suggested versions\n%-40s = ", "Export-Package");
        String del = "";
        for (Baseline.Info info : infos) {
            out.append(del);
            out.printf("\\\n  ", new Object[0]);
            out.append(info.packageName);
            info.attributes.put("version", info.suggestedVersion.toString());
            for (Map.Entry<String, String> clause : info.attributes.entrySet()) {
                if (clause.getKey().equals("uses:")) continue;
                out.append(";\\\n    ");
                out.append(clause.getKey());
                out.append("=");
                Processor.quote(out, clause.getValue());
            }
            if (info.providers != null && !info.providers.isEmpty()) {
                out.append(";\\\n    x-provider-type:=\"");
                String del2 = "";
                for (String part : info.providers) {
                    out.append(del2);
                    out.append("\\\n        ");
                    out.append(part);
                    del2 = ",";
                }
                out.append("\"");
            }
            del = ",";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PSpec
    implements Comparable<PSpec> {
        String packageName;
        Version version;
        int id;
        public Attrs attrs;
        public Tree tree;
        public Attrs uses = new Attrs(new Attrs[0]);

        PSpec() {
        }

        @Override
        public int compareTo(PSpec o) {
            return this.version.compareTo(o.version);
        }
    }

    @Description(value="Print out the packages from spec jars and check in which ees they appear. Very specific. For example, schema -ee j2se-1.6.0 -ee j2se-1.5.0 -ee j2ee-1.4.0 javax.activation-1.1.jar")
    static interface schemaOptions
    extends Options {
        @Description(value="Output file")
        public String output(String var1);

        @Description(value="Specify an XSL file for pretty printing")
        public String xsl();
    }

    @Description(value="Compare a newer bundle to a baselined bundle and provide versioning advice")
    @Arguments(arg={"[newer jar]", "[older jar]"})
    static interface baseLineOptions
    extends Options {
        @Description(value="Output file with fixup info")
        public String fixup();
    }
}

