/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMException;
import jodd.lagarto.dom.Node;
import jodd.util.HtmlDecoder;
import jodd.util.HtmlEncoder;
import jodd.util.StringUtil;

public class Text
extends Node {
    protected Boolean blank;

    public Text(Document ownerDocument, String text) {
        super(ownerDocument, Node.NodeType.TEXT, null);
        this.nodeValue = text;
    }

    public Text clone() {
        return this.cloneTo(new Text(this.ownerDocument, this.nodeValue));
    }

    public boolean isBlank() {
        if (this.blank == null) {
            this.blank = StringUtil.isBlank(this.nodeValue);
        }
        return this.blank;
    }

    public void setTextContent(String text) {
        this.nodeValue = HtmlEncoder.text(text);
    }

    public String getTextContent() {
        return HtmlDecoder.decode(this.nodeValue);
    }

    public void appendTextContent(Appendable appendable) {
        try {
            appendable.append(this.getTextContent());
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    public void setTextStrict(String text) {
        this.nodeValue = HtmlEncoder.strict(text);
    }

    public void toHtml(Appendable appendable) throws IOException {
        this.ownerDocument.getRenderer().renderText(this, appendable);
    }
}

