/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.parser;

import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.parser.HeadingListener;
import com.ecyrd.jspwiki.parser.WikiDocument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;

public abstract class MarkupParser {
    protected static final int PUSHBACK_BUFFER_SIZE = 10240;
    protected PushbackReader m_in;
    private int m_pos = -1;
    protected WikiEngine m_engine;
    protected WikiContext m_context;
    protected ArrayList<StringTransmutator> m_localLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_externalLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_attachmentLinkMutatorChain = new ArrayList();
    protected ArrayList<HeadingListener> m_headingListenerChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_linkMutators = new ArrayList();
    protected boolean m_inlineImages = true;
    protected boolean m_parseAccessRules = true;
    public static final String PROP_ALLOWHTML = "jspwiki.translatorReader.allowHTML";
    public static final String PROP_RUNPLUGINS = "jspwiki.translatorReader.runPlugins";
    protected static final String LEGACY_CHARS_ALLOWED = "._";
    public static final String PUNCTUATION_CHARS_ALLOWED = " ()&+,-=._$";

    protected MarkupParser(WikiContext context, Reader in) {
        this.m_engine = context.getEngine();
        this.m_context = context;
        this.setInputReader(in);
    }

    public Reader setInputReader(Reader in) {
        PushbackReader old = this.m_in;
        if (in != null) {
            this.m_in = new PushbackReader(new BufferedReader(in), 10240);
        }
        return old;
    }

    public void addLinkTransmutator(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_linkMutators.add(mutator);
        }
    }

    public void addLocalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_localLinkMutatorChain.add(mutator);
        }
    }

    public void addExternalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_externalLinkMutatorChain.add(mutator);
        }
    }

    public void addAttachmentLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_attachmentLinkMutatorChain.add(mutator);
        }
    }

    public void addHeadingListener(HeadingListener listener) {
        if (listener != null) {
            this.m_headingListenerChain.add(listener);
        }
    }

    public void disableAccessRules() {
        this.m_parseAccessRules = false;
    }

    public void enableImageInlining(boolean toggle) {
        this.m_inlineImages = toggle;
    }

    public abstract WikiDocument parse() throws IOException;

    public int getPosition() {
        return this.m_pos;
    }

    protected final int nextToken() throws IOException, NullPointerException {
        ++this.m_pos;
        return this.m_in.read();
    }

    protected void pushBack(int c) throws IOException {
        if (c != -1 && this.m_in != null) {
            --this.m_pos;
            this.m_in.unread(c);
        }
    }

    public static String cleanLink(String link) {
        return MarkupParser.cleanLink(link, PUNCTUATION_CHARS_ALLOWED);
    }

    public static String cleanLink(String link, String allowedChars) {
        if (link == null) {
            return null;
        }
        link = link.trim();
        StringBuffer clean = new StringBuffer(link.length());
        boolean isWord = true;
        boolean wasSpace = false;
        for (int i = 0; i < link.length(); ++i) {
            char ch = link.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (wasSpace) continue;
                wasSpace = true;
            } else {
                wasSpace = false;
            }
            if (Character.isLetterOrDigit(ch) || allowedChars.indexOf(ch) != -1) {
                if (isWord) {
                    ch = Character.toUpperCase(ch);
                }
                clean.append(ch);
                isWord = false;
                continue;
            }
            isWord = true;
        }
        return clean.toString();
    }

    public static String wikifyLink(String link) {
        return MarkupParser.cleanLink(link, LEGACY_CHARS_ALLOWED);
    }
}

