/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.compiler.ir.operands.Constant;
import org.jruby.interpreter.InterpreterContext;

public class BooleanLiteral
extends Constant {
    public static final BooleanLiteral TRUE = new BooleanLiteral();
    public static final BooleanLiteral FALSE = new BooleanLiteral();

    private BooleanLiteral() {
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public BooleanLiteral logicalNot() {
        return this.isTrue() ? FALSE : TRUE;
    }

    public String toString() {
        return this.isTrue() ? "true" : "false";
    }

    public Object retrieve(InterpreterContext interp) {
        if (this.cachedValue == null) {
            this.cachedValue = interp.getRuntime().newBoolean(this.isTrue());
        }
        return this.cachedValue;
    }
}

