/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.DirectoryScanner;

public class SourceFormatterHelper {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private Properties _properties = new Properties();
    private String _propertiesContent = "";
    private File _propertiesFile;
    private boolean _useProperties;

    public SourceFormatterHelper(boolean useProperties) {
        this._useProperties = useProperties;
    }

    public void close() throws IOException {
        if (!this._useProperties) {
            return;
        }
        String newPropertiesContent = PropertiesUtil.toString((Properties)this._properties);
        if (!this._propertiesContent.equals(newPropertiesContent)) {
            _fileUtil.write(this._propertiesFile, newPropertiesContent);
        }
    }

    public void init() throws IOException {
        if (!this._useProperties) {
            return;
        }
        File basedirFile = new File("./");
        String basedirAbsolutePath = StringUtil.replace((String)basedirFile.getAbsolutePath(), (String[])new String[]{".", ":", "/", "\\"}, (String[])new String[]{"_", "_", "_", "_"});
        String propertiesFileName = String.valueOf(System.getProperty("java.io.tmpdir")) + "/SourceFormatter." + basedirAbsolutePath;
        this._propertiesFile = new File(propertiesFileName);
        if (this._propertiesFile.exists()) {
            this._propertiesContent = _fileUtil.read(this._propertiesFile);
            PropertiesUtil.load((Properties)this._properties, (String)this._propertiesContent);
        }
    }

    public void printError(String fileName, File file) {
        this.printError(fileName, file.toString());
    }

    public void printError(String fileName, String message) {
        if (this._useProperties) {
            String encodedFileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            this._properties.remove(encodedFileName);
        }
        System.out.println(message);
    }

    public List<String> scanForFiles(DirectoryScanner directoryScanner) {
        directoryScanner.scan();
        Object[] fileNamesArray = directoryScanner.getIncludedFiles();
        if (!this._useProperties) {
            return ListUtil.toList((Object[])fileNamesArray);
        }
        ArrayList<String> fileNames = new ArrayList<String>(fileNamesArray.length);
        Object[] objectArray = fileNamesArray;
        int n = fileNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object fileName = objectArray[n2];
            File file = new File((String)fileName);
            String encodedFileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            long timestamp = GetterUtil.getLong((String)this._properties.getProperty(encodedFileName));
            if (timestamp < file.lastModified()) {
                fileNames.add((String)fileName);
                this._properties.setProperty(encodedFileName, String.valueOf(file.lastModified()));
            }
            ++n2;
        }
        return fileNames;
    }
}

