/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyActionableDynamicQuery;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletURL;

public class AssetVocabularyIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{AssetVocabulary.class.getName()};
    public static final String PORTLET_ID = "147";
    private static final boolean _FILTER_SEARCH = true;
    private static final boolean _PERMISSION_AWARE = true;
    private static Log _log = LogFactoryUtil.getLog(AssetVocabularyIndexer.class);

    public AssetVocabularyIndexer() {
        this.setCommitImmediately(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)entryClassPK);
        return AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW");
    }

    public boolean isFilterSearch() {
        return true;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull((String)title)) {
            BooleanQuery localizedQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        this.deleteDocument(vocabulary.getCompanyId(), vocabulary.getVocabularyId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing vocabulary " + vocabulary));
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)vocabulary);
        document.addKeyword("assetVocabularyId", vocabulary.getVocabularyId());
        document.addLocalizedText("description", vocabulary.getDescriptionMap());
        document.addText("name", vocabulary.getName());
        document.addLocalizedText("title", vocabulary.getTitleMap());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + vocabulary + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        Document document = this.getDocument(vocabulary);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)vocabulary.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)classPK);
        this.doReindex(vocabulary);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexVocabularies(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexVocabularies(long companyId) throws PortalException, SystemException {
        final ArrayList documents = new ArrayList();
        AssetVocabularyActionableDynamicQuery actionableDynamicQuery = new AssetVocabularyActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                AssetVocabulary vocabulary = (AssetVocabulary)object;
                Document document = AssetVocabularyIndexer.this.getDocument(vocabulary);
                if (document != null) {
                    documents.add(document);
                }
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

