/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.JmxConnectionPoolMonitorMBean;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class JmxConnectionPoolMonitor
implements JmxConnectionPoolMonitorMBean {
    private final ConnectionPool<?> pool;
    private static final int DEFAULT_PORT = 7102;

    public JmxConnectionPoolMonitor(ConnectionPool<?> pool) {
        this.pool = pool;
    }

    @Override
    public boolean addHost(String host) {
        return this.pool.addHost(new Host(host, 7102), true);
    }

    @Override
    public boolean removeHost(String host) {
        return this.pool.removeHost(new Host(host, 7102), true);
    }

    @Override
    public boolean isHostUp(String host) {
        return this.pool.isHostUp(new Host(host, 7102));
    }

    @Override
    public boolean hasHost(String host) {
        return this.pool.hasHost(new Host(host, 7102));
    }

    @Override
    public String getActiveHosts() {
        return StringUtils.join((Collection)Lists.transform(this.pool.getActivePools(), (Function)new Function<HostConnectionPool<?>, String>(){

            public String apply(HostConnectionPool<?> host) {
                return host.getHost().getName();
            }
        }), (String)",");
    }
}

