/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.impl.TokenHostConnectionPoolPartition;
import com.netflix.astyanax.connectionpool.impl.Topology;
import com.netflix.astyanax.partitioner.Partitioner;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class TokenPartitionedTopology<CL>
implements Topology<CL> {
    private AtomicReference<List<TokenHostConnectionPoolPartition<CL>>> sortedRing = new AtomicReference(new ArrayList());
    private NonBlockingHashMap<BigInteger, TokenHostConnectionPoolPartition<CL>> tokenToPartitionMap = new NonBlockingHashMap();
    private TokenHostConnectionPoolPartition<CL> allPools;
    private LatencyScoreStrategy strategy;
    private final Partitioner partitioner;
    private Comparator tokenSearchComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            TokenHostConnectionPoolPartition partition = (TokenHostConnectionPoolPartition)arg0;
            BigInteger token = (BigInteger)arg1;
            return partition.id().compareTo(token);
        }
    };
    private Comparator partitionComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            TokenHostConnectionPoolPartition partition0 = (TokenHostConnectionPoolPartition)arg0;
            TokenHostConnectionPoolPartition partition1 = (TokenHostConnectionPoolPartition)arg1;
            return partition0.id().compareTo(partition1.id());
        }
    };

    public TokenPartitionedTopology(Partitioner partitioner, LatencyScoreStrategy strategy) {
        this.strategy = strategy;
        this.partitioner = partitioner;
        this.allPools = new TokenHostConnectionPoolPartition(null, this.strategy);
    }

    protected TokenHostConnectionPoolPartition<CL> makePartition(BigInteger partition) {
        return new TokenHostConnectionPoolPartition(partition, this.strategy);
    }

    @Override
    public synchronized boolean setPools(Collection<HostConnectionPool<CL>> ring) {
        boolean didChange = false;
        HashSet allPools = Sets.newHashSet();
        HashMap tokenHostMap = Maps.newHashMap();
        for (HostConnectionPool<CL> pool : ring) {
            allPools.add(pool);
            if (!this.allPools.hasPool(pool)) {
                didChange = true;
            }
            for (TokenRange range : pool.getHost().getTokenRanges()) {
                BigInteger endToken = new BigInteger(range.getEndToken());
                List partition = (List)tokenHostMap.get(endToken);
                if (partition == null) {
                    partition = Lists.newArrayList();
                    tokenHostMap.put(endToken, partition);
                }
                partition.add(pool);
            }
        }
        HashSet tokensToRemove = Sets.newHashSet(tokenHostMap.keySet());
        for (Map.Entry entry : tokenHostMap.entrySet()) {
            BigInteger token = (BigInteger)entry.getKey();
            tokensToRemove.remove(token);
            TokenHostConnectionPoolPartition<CL> partition = (TokenHostConnectionPoolPartition<CL>)this.tokenToPartitionMap.get((Object)token);
            if (partition == null) {
                partition = this.makePartition(token);
                this.tokenToPartitionMap.put((Object)token, partition);
                didChange = true;
            }
            if (!partition.setPools((Collection)entry.getValue())) continue;
            didChange = true;
        }
        for (BigInteger token : tokensToRemove) {
            tokenHostMap.remove(token);
            didChange = true;
        }
        if (didChange) {
            ArrayList partitions = Lists.newArrayList((Iterable)this.tokenToPartitionMap.values());
            Collections.sort(partitions, this.partitionComparator);
            this.allPools.setPools(allPools);
            this.refresh();
            this.sortedRing.set(Collections.unmodifiableList(partitions));
        }
        return didChange;
    }

    @Override
    public synchronized void resumePool(HostConnectionPool<CL> pool) {
        this.refresh();
    }

    @Override
    public synchronized void suspendPool(HostConnectionPool<CL> pool) {
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        this.allPools.refresh();
        for (TokenHostConnectionPoolPartition partition : this.tokenToPartitionMap.values()) {
            partition.refresh();
        }
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getPartition(String token) {
        return (TokenHostConnectionPoolPartition)this.tokenToPartitionMap.get((Object)new BigInteger(token));
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getPartition(ByteBuffer rowkey) {
        if (rowkey == null) {
            return this.getAllPools();
        }
        BigInteger token = new BigInteger(this.partitioner.getTokenForKey(rowkey));
        List<TokenHostConnectionPoolPartition<CL>> partitions = this.sortedRing.get();
        if (token == null || partitions == null || partitions.isEmpty()) {
            return this.getAllPools();
        }
        int partitionIndex = Collections.binarySearch(partitions, token, this.tokenSearchComparator);
        if (partitionIndex < 0) {
            partitionIndex = -(partitionIndex + 1);
        }
        return partitions.get(partitionIndex % partitions.size());
    }

    @Override
    public TokenHostConnectionPoolPartition<CL> getAllPools() {
        return this.allPools;
    }

    @Override
    public int getPartitionCount() {
        return this.tokenToPartitionMap.size();
    }

    @Override
    public synchronized void removePool(HostConnectionPool<CL> pool) {
        this.allPools.removePool(pool);
        for (TokenHostConnectionPoolPartition partition : this.tokenToPartitionMap.values()) {
            partition.removePool(pool);
        }
    }

    @Override
    public synchronized void addPool(HostConnectionPool<CL> pool) {
        this.allPools.addPool(pool);
    }

    @Override
    public List<String> getPartitionNames() {
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)this.tokenToPartitionMap.keySet(), (Function)new Function<BigInteger, String>(){

            public String apply(BigInteger input) {
                return input.toString();
            }
        }));
    }

    @Override
    public Map<String, TokenHostConnectionPoolPartition<CL>> getPartitions() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : this.tokenToPartitionMap.entrySet()) {
            result.put(((BigInteger)entry.getKey()).toString(), entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TokenPartitionTopology[");
        sb.append(StringUtils.join((Collection)Lists.transform(this.sortedRing.get(), (Function)new Function<TokenHostConnectionPoolPartition<CL>, String>(){

            public String apply(TokenHostConnectionPoolPartition<CL> input) {
                return input.id().toString() + "\n";
            }
        }), (String)","));
        sb.append("]");
        return sb.toString();
    }
}

