/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.SessionInterface;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BitType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Scanner {
    static final char[] specials = new char[]{'\"', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '\\', ':', ';', '<', '=', '>', '?', '[', ']', '^', '_', '|', '{', '}'};
    static final String[] multi = new String[]{"??(", "??)", "<>", ">=", "<=", "||", "->", "::", "..", "--", "/*", "*/"};
    static final char[] whitespace = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', ' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202f', '\u205f', '\u3000', '\u2028', '\u2029'};
    static final OrderedIntHashSet whiteSpaceSet = new OrderedIntHashSet(32);
    String sqlString;
    int currentPosition;
    int tokenPosition;
    int limit;
    Token token = new Token();
    boolean nullAndBooleanAsValue;
    private boolean hasNonSpaceSeparator;
    private int eolPosition;
    private int lineNumber;
    private int eolCode;
    private static final int maxPooledStringLength;
    char[] charBuffer = new char[256];
    CharArrayWriter charWriter = new CharArrayWriter(this.charBuffer);
    byte[] byteBuffer = new byte[256];
    HsqlByteArrayOutputStream byteOutputStream = new HsqlByteArrayOutputStream(this.byteBuffer);
    private String intervalString;
    private int intervalPosition;
    private int intervalPrecision;
    private int fractionPrecision;
    Type dateTimeType;

    public Scanner() {
    }

    Scanner(String sql) {
        this.reset(sql);
    }

    public void reset(String sql) {
        this.sqlString = sql;
        this.currentPosition = 0;
        this.tokenPosition = 0;
        this.limit = this.sqlString.length();
        this.hasNonSpaceSeparator = false;
        this.eolPosition = -1;
        this.lineNumber = 1;
        this.token.reset();
        this.token.tokenType = 849;
    }

    void resetState() {
        this.tokenPosition = this.currentPosition;
        this.token.reset();
    }

    public void setNullAndBooleanAsValue() {
        this.nullAndBooleanAsValue = true;
    }

    public void scanNext() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 848;
            return;
        }
        if (this.scanSeparator()) {
            // empty if block
        }
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 848;
            return;
        }
        boolean needsDelimiter = !this.token.isDelimiter;
        this.scanToken();
        if (!needsDelimiter || !this.token.isDelimiter) {
            // empty if block
        }
        if (this.token.isMalformed) {
            this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
        }
    }

    public void scanEnd() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 848;
        }
    }

    public Token getToken() {
        return this.token;
    }

    public String getString() {
        return this.token.tokenString;
    }

    public int getTokenType() {
        return this.token.tokenType;
    }

    public Object getValue() {
        return this.token.tokenValue;
    }

    public Type getDataType() {
        return this.token.dataType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    int getTokenPosition() {
        return this.tokenPosition;
    }

    int getPosition() {
        return this.tokenPosition;
    }

    void position(int position) {
        this.currentPosition = this.tokenPosition = position;
    }

    String getPart(int start, int end) {
        return this.sqlString.substring(start, end);
    }

    private int charAt(int i) {
        if (i >= this.limit) {
            return -1;
        }
        return this.sqlString.charAt(i);
    }

    void scanBinaryString() {
        this.byteOutputStream.reset(this.byteBuffer);
        do {
            this.scanBinaryStringPart();
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
    }

    static int getHexValue(int c) {
        c = c >= 48 && c <= 57 ? (c -= 48) : (c > 122 ? 16 : (c >= 97 ? (c -= 87) : (c > 90 ? 16 : (c >= 65 ? (c -= 55) : -1))));
        return c;
    }

    public void scanBinaryStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 856;
            this.token.isMalformed = true;
            return;
        }
        this.scanBinaryString();
    }

    void scanBinaryStringPart() {
        boolean complete = false;
        boolean hi = true;
        byte b = 0;
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            int c = this.sqlString.charAt(this.currentPosition);
            if (c != 32) {
                if (c == 39) {
                    complete = true;
                    ++this.currentPosition;
                    break;
                }
                if ((c = Scanner.getHexValue(c)) == -1) {
                    this.token.tokenType = 856;
                    this.token.isMalformed = true;
                    return;
                }
                if (hi) {
                    b = (byte)(c << 4);
                    hi = false;
                } else {
                    b = (byte)(b + (byte)c);
                    this.byteOutputStream.writeByte(b);
                    hi = true;
                }
            }
            ++this.currentPosition;
        }
        if (!hi) {
            this.token.tokenType = 856;
            this.token.isMalformed = true;
            return;
        }
        if (!complete) {
            this.token.tokenType = 856;
            this.token.isMalformed = true;
            return;
        }
    }

    void scanBitString() {
        BitMap map = new BitMap(32);
        do {
            this.scanBitStringPart(map);
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = BinaryData.getBitData(map.getBytes(), map.size());
    }

    public void scanBitStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 855;
            this.token.isMalformed = true;
            return;
        }
        this.scanBitString();
    }

    void scanBitStringPart(BitMap map) {
        boolean complete = false;
        int bitIndex = map.size();
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c != ' ') {
                if (c == '\'') {
                    complete = true;
                    ++this.currentPosition;
                    break;
                }
                if (c == '0') {
                    ++bitIndex;
                } else if (c == '1') {
                    map.set(bitIndex);
                    ++bitIndex;
                } else {
                    this.token.tokenType = 855;
                    this.token.isMalformed = true;
                    return;
                }
            }
            ++this.currentPosition;
        }
        if (!complete) {
            this.token.tokenType = 855;
            this.token.isMalformed = true;
            return;
        }
        map.setSize(bitIndex);
    }

    void convertUnicodeString(int escape) {
        this.charWriter.reset(this.charBuffer);
        int position = 0;
        while (true) {
            int nextIndex;
            if ((nextIndex = this.token.tokenString.indexOf(escape, position)) < 0) {
                nextIndex = this.token.tokenString.length();
            }
            this.charWriter.write(this.token.tokenString, position, nextIndex - position);
            if (nextIndex == this.token.tokenString.length()) break;
            if (++nextIndex == this.token.tokenString.length()) {
                this.token.tokenType = 857;
                this.token.isMalformed = true;
                return;
            }
            if (this.token.tokenString.charAt(nextIndex) == escape) {
                this.charWriter.write(escape);
                position = ++nextIndex;
                continue;
            }
            if (nextIndex > this.token.tokenString.length() - 4) {
                this.token.tokenType = 857;
                this.token.isMalformed = true;
                return;
            }
            int hexCount = 4;
            int hexIndex = 0;
            int hexValue = 0;
            if (this.token.tokenString.charAt(nextIndex) == '+') {
                if (++nextIndex > this.token.tokenString.length() - 6) {
                    this.token.tokenType = 857;
                    this.token.isMalformed = true;
                    return;
                }
                hexIndex = 2;
                hexCount = 8;
            }
            while (hexIndex < hexCount) {
                int character = this.token.tokenString.charAt(position++);
                if ((character = Scanner.getHexValue(character)) == -1) {
                    this.token.tokenType = 857;
                    this.token.isMalformed = true;
                    return;
                }
                hexValue |= character << (hexCount - hexIndex - 1) * 4;
                ++hexIndex;
            }
            if (hexCount == 8) {
                this.charWriter.write(hexValue >>> 16);
            }
            this.charWriter.write(hexValue & (hexValue & 0xFFFF));
            this.token.tokenValue = this.charWriter.toString();
        }
    }

    public boolean scanSpecialIdentifier(String identifier) {
        int length = identifier.length();
        if (this.limit - this.currentPosition < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char character = identifier.charAt(i);
            if (character == this.sqlString.charAt(this.currentPosition + i) || character == Character.toUpperCase(this.sqlString.charAt(this.currentPosition + i))) continue;
            return false;
        }
        this.currentPosition += length;
        return true;
    }

    private int scanEscapeDefinition() {
        int c = this.charAt(this.currentPosition);
        if (c == 39) {
            ++this.currentPosition;
            if (!this.scanWhitespace() && Scanner.getHexValue(c = this.charAt(this.currentPosition)) == -1 && c != 43 && c != 39 && c != 34) {
                int escape = c;
                ++this.currentPosition;
                c = this.charAt(this.currentPosition);
                if (c == 39) {
                    ++this.currentPosition;
                    return escape;
                }
            }
        }
        return -1;
    }

    private void scanUnicodeString() {
        int escape = 92;
        this.scanCharacterString();
        this.scanSeparator();
        int c = this.charAt(this.currentPosition);
        if ((c == 117 || c == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            escape = this.scanEscapeDefinition();
            if (escape == -1) {
                this.token.tokenType = 860;
                this.token.isMalformed = true;
                return;
            }
        }
        this.convertUnicodeString(escape);
    }

    private boolean scanUnicodeIdentifier() {
        int escape = 92;
        this.scanStringPart('\"');
        if (this.token.isMalformed) {
            return false;
        }
        this.token.tokenString = this.charWriter.toString();
        int c = this.charAt(this.currentPosition);
        if ((c == 117 || c == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            escape = this.scanEscapeDefinition();
            if (escape == -1) {
                this.token.tokenType = 860;
                this.token.isMalformed = true;
                return false;
            }
        }
        this.convertUnicodeString(escape);
        return !this.token.isMalformed;
    }

    boolean shiftPrefixes() {
        if (this.token.namePrePrePrefix != null) {
            return false;
        }
        this.token.namePrePrePrefix = this.token.namePrePrefix;
        this.token.isDelimitedPrePrePrefix = this.token.isDelimitedPrePrefix;
        this.token.namePrePrefix = this.token.namePrefix;
        this.token.isDelimitedPrePrefix = this.token.isDelimitedPrefix;
        this.token.namePrefix = this.token.tokenString;
        this.token.isDelimitedPrefix = this.token.tokenType == 847;
        return true;
    }

    private void scanIdentifierChain() {
        int c = this.charAt(this.currentPosition);
        switch (c) {
            case 34: {
                this.charWriter.reset(this.charBuffer);
                this.scanStringPart('\"');
                if (this.token.isMalformed) {
                    return;
                }
                this.token.tokenType = 847;
                this.token.tokenString = this.charWriter.toString();
                this.token.isDelimiter = true;
                break;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) == 38 && this.charAt(this.currentPosition + 1) == 34) {
                    this.currentPosition += 3;
                    boolean result = this.scanUnicodeIdentifier();
                    if (!result) {
                        return;
                    }
                    this.token.tokenType = 847;
                    this.token.isDelimiter = false;
                    break;
                }
            }
            default: {
                boolean result = this.scanUndelimitedIdentifier();
                if (!result) {
                    return;
                }
                this.token.tokenType = 846;
                this.token.isDelimiter = false;
            }
        }
        c = this.charAt(this.currentPosition);
        if (c == 46) {
            ++this.currentPosition;
            c = this.charAt(this.currentPosition);
            if (c == 42) {
                ++this.currentPosition;
                this.shiftPrefixes();
                this.token.tokenString = "*";
                this.token.tokenType = 771;
            } else {
                this.shiftPrefixes();
                this.scanIdentifierChain();
            }
        }
    }

    public boolean scanUndelimitedIdentifier() {
        int tokenLength;
        char c;
        int i;
        if (this.currentPosition == this.limit) {
            return false;
        }
        char start = this.sqlString.charAt(this.currentPosition);
        if (!Character.isLetter(start)) {
            this.token.tokenString = Character.toString(start);
            this.token.tokenType = -1;
            this.token.isMalformed = true;
            return false;
        }
        for (i = this.currentPosition + 1; i < this.limit && ((c = this.sqlString.charAt(i)) == '_' || Character.isLetterOrDigit(c)); ++i) {
        }
        this.token.tokenString = this.sqlString.substring(this.currentPosition, i).toUpperCase(Locale.ENGLISH);
        this.currentPosition = i;
        if (this.nullAndBooleanAsValue && ((tokenLength = this.currentPosition - this.tokenPosition) == 4 || tokenLength == 5)) {
            switch (start) {
                case 'T': 
                case 't': {
                    if (!"TRUE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "TRUE";
                    this.token.tokenType = 845;
                    this.token.tokenValue = Boolean.TRUE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'F': 
                case 'f': {
                    if (!"FALSE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "FALSE";
                    this.token.tokenType = 845;
                    this.token.tokenValue = Boolean.FALSE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'N': 
                case 'n': {
                    if (!"NULL".equals(this.token.tokenString)) break;
                    this.token.tokenString = "NULL";
                    this.token.tokenType = 845;
                    this.token.tokenValue = null;
                    return false;
                }
            }
        }
        return true;
    }

    void scanNumber() {
        boolean hasDigit = false;
        boolean hasPoint = false;
        int exponentIndex = -1;
        this.token.tokenType = 845;
        this.token.dataType = Type.SQL_INTEGER;
        int tokenStart = this.currentPosition;
        while (this.currentPosition < this.limit) {
            boolean end = false;
            int c = this.charAt(this.currentPosition);
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    hasDigit = true;
                    break;
                }
                case 46: {
                    this.token.dataType = Type.SQL_NUMERIC;
                    if (hasPoint || exponentIndex != -1) {
                        this.token.tokenString = this.sqlString.substring(tokenStart, this.currentPosition + 1);
                        this.token.tokenType = 854;
                        this.token.isMalformed = true;
                        return;
                    }
                    hasPoint = true;
                    break;
                }
                case 69: 
                case 101: {
                    this.token.dataType = Type.SQL_DOUBLE;
                    if (exponentIndex != -1 || !hasDigit) {
                        this.token.tokenString = this.sqlString.substring(tokenStart, this.currentPosition + 1);
                        this.token.tokenType = 854;
                        this.token.isMalformed = true;
                        return;
                    }
                    hasPoint = true;
                    exponentIndex = this.currentPosition;
                    break;
                }
                case 43: 
                case 45: {
                    if (exponentIndex == this.currentPosition - 1) break;
                    end = true;
                    break;
                }
                case 71: 
                case 75: 
                case 77: 
                case 80: 
                case 84: 
                case 103: 
                case 107: 
                case 109: 
                case 112: 
                case 116: {
                    if (!hasDigit || hasPoint) {
                        this.token.tokenType = 854;
                        this.token.isMalformed = true;
                        return;
                    }
                    String s = Character.toString((char)c).toUpperCase(Locale.ENGLISH);
                    this.token.lobMultiplierType = Tokens.getNonKeywordID(s, 854);
                    if (this.token.lobMultiplierType == 854) {
                        this.token.tokenType = 854;
                        this.token.isMalformed = true;
                        return;
                    }
                    try {
                        this.token.tokenValue = ValuePool.getInt(Integer.parseInt(this.sqlString.substring(tokenStart, this.currentPosition)));
                        this.token.tokenType = 852;
                        ++this.currentPosition;
                        this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
                    }
                    catch (NumberFormatException e) {
                        this.token.tokenType = 854;
                        this.token.isMalformed = true;
                    }
                    return;
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            ++this.currentPosition;
        }
        this.token.tokenString = this.sqlString.substring(tokenStart, this.currentPosition);
        switch (this.token.dataType.typeCode) {
            case 4: {
                if (this.token.tokenString.length() < 11) {
                    try {
                        this.token.tokenValue = ValuePool.getInt(Integer.parseInt(this.token.tokenString));
                        return;
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                if (this.token.tokenString.length() < 20) {
                    try {
                        this.token.dataType = Type.SQL_BIGINT;
                        this.token.tokenValue = ValuePool.getLong(Long.parseLong(this.token.tokenString));
                        return;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                this.token.dataType = Type.SQL_NUMERIC;
            }
            case 2: {
                try {
                    BigDecimal decimal = new BigDecimal(this.token.tokenString);
                    this.token.tokenValue = decimal;
                    this.token.dataType = NumberType.getNumberType(2, JavaSystem.precision(decimal), decimal.scale());
                }
                catch (Exception e2) {
                    this.token.tokenType = 854;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
            case 8: {
                try {
                    double d = JavaSystem.parseDouble(this.token.tokenString);
                    long l = Double.doubleToLongBits(d);
                    this.token.tokenValue = ValuePool.getDouble(l);
                }
                catch (Exception e2) {
                    this.token.tokenType = 854;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
        }
    }

    boolean scanSeparator() {
        boolean result = false;
        while (true) {
            boolean whiteSpace = this.scanWhitespace();
            result |= whiteSpace;
            if (!this.scanCommentAsInlineSeparator()) break;
            result = true;
            this.hasNonSpaceSeparator = true;
        }
        return result;
    }

    boolean scanCommentAsInlineSeparator() {
        int character = this.charAt(this.currentPosition);
        if (character == 45 && this.charAt(this.currentPosition + 1) == 45) {
            int pos = this.sqlString.indexOf(13, this.currentPosition + 2);
            if (pos == -1) {
                pos = this.sqlString.indexOf(10, this.currentPosition + 2);
            } else if (this.charAt(pos + 1) == 10) {
                ++pos;
            }
            this.currentPosition = pos == -1 ? this.limit : pos + 1;
            return true;
        }
        if (character == 47 && this.charAt(this.currentPosition + 1) == 42) {
            int pos = this.sqlString.indexOf("*/", this.currentPosition + 2);
            if (pos == -1) {
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = 858;
                this.token.isMalformed = true;
                return false;
            }
            this.currentPosition = pos + 2;
            return true;
        }
        return false;
    }

    public boolean scanWhitespace() {
        boolean result = false;
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c == ' ') {
                result = true;
            } else {
                if (!whiteSpaceSet.contains(c)) break;
                this.hasNonSpaceSeparator = true;
                result = true;
                this.setLineNumber(c);
            }
            ++this.currentPosition;
        }
        return result;
    }

    private void setLineNumber(int c) {
        if (c == 13 || c == 10) {
            if (this.currentPosition == this.eolPosition + 1) {
                if (c != 10 || this.eolCode == c) {
                    ++this.lineNumber;
                }
            } else {
                ++this.lineNumber;
            }
            this.eolPosition = this.currentPosition;
            this.eolCode = c;
        }
    }

    void scanCharacterString() {
        this.charWriter.reset(this.charBuffer);
        do {
            this.scanStringPart('\'');
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenString = this.charWriter.toString();
        this.token.tokenValue = this.token.tokenString;
    }

    public void scanStringPart(char quoteChar) {
        int nextIndex;
        ++this.currentPosition;
        while (true) {
            if ((nextIndex = this.sqlString.indexOf(quoteChar, this.currentPosition)) < 0) {
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.limit);
                this.token.tokenType = quoteChar == '\'' ? 853 : 859;
                this.token.isMalformed = true;
                return;
            }
            if (this.charAt(nextIndex + 1) != quoteChar) break;
            this.charWriter.write(this.sqlString, this.currentPosition, ++nextIndex - this.currentPosition);
            this.currentPosition = nextIndex + 1;
        }
        this.charWriter.write(this.sqlString, this.currentPosition, nextIndex - this.currentPosition);
        this.currentPosition = nextIndex + 1;
    }

    void scanToken() {
        int character = this.charAt(this.currentPosition);
        this.resetState();
        this.token.tokenType = 846;
        switch (character) {
            case 91: {
                this.token.tokenString = "[";
                this.token.tokenType = 781;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 93: {
                this.token.tokenString = "]";
                this.token.tokenType = 790;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 40: {
                this.token.tokenString = "(";
                this.token.tokenType = 786;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 41: {
                this.token.tokenString = ")";
                this.token.tokenType = 772;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 44: {
                this.token.tokenString = ",";
                this.token.tokenType = 774;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 42: {
                this.token.tokenString = "*";
                this.token.tokenType = 771;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 61: {
                this.token.tokenString = "=";
                this.token.tokenType = 396;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 59: {
                this.token.tokenString = ";";
                this.token.tokenType = 791;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 43: {
                this.token.tokenString = "+";
                this.token.tokenType = 787;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 58: {
                if (this.charAt(this.currentPosition + 1) == 58) {
                    this.currentPosition += 2;
                    this.token.tokenString = "::";
                    this.token.tokenType = 773;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ":";
                this.token.tokenType = 773;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 63: {
                if (this.charAt(this.currentPosition + 1) == 63) {
                    if (this.charAt(this.currentPosition + 2) == 40) {
                        this.token.tokenString = "[";
                        this.token.tokenType = 781;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                    if (this.charAt(this.currentPosition + 2) == 41) {
                        this.token.tokenString = "]";
                        this.token.tokenType = 790;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                }
                this.token.tokenString = "?";
                this.token.tokenType = 788;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 33: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 785;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 60: {
                if (this.charAt(this.currentPosition + 1) == 62) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 785;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<=";
                    this.token.tokenType = 783;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "<";
                this.token.tokenType = 782;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 62: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = ">=";
                    this.token.tokenType = 780;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ">";
                this.token.tokenType = 779;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 124: {
                if (this.charAt(this.currentPosition + 1) == 124) {
                    this.token.tokenString = "||";
                    this.token.tokenType = 775;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 47: {
                if (this.charAt(this.currentPosition + 1) == 47) {
                    int pos = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (pos == -1) {
                        pos = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (pos == -1) {
                        pos = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, pos);
                    this.token.tokenType = 850;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 42) {
                    int pos = this.sqlString.indexOf("*/", this.currentPosition + 2);
                    if (pos == -1) {
                        this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                        this.token.tokenType = -1;
                        this.token.isDelimiter = true;
                        return;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, pos);
                    this.token.tokenType = 850;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "/";
                this.token.tokenType = 776;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 45: {
                if (this.charAt(this.currentPosition + 1) == 45) {
                    int pos = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (pos == -1) {
                        pos = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (pos == -1) {
                        pos = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, pos);
                    this.token.tokenType = 850;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "-";
                this.token.tokenType = 784;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 34: {
                this.token.tokenType = 847;
                break;
            }
            case 39: {
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = CharacterType.getCharacterType(1, this.token.tokenString.length());
                this.token.tokenType = 845;
                this.token.isDelimiter = true;
                return;
            }
            case 88: 
            case 120: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBinaryString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BinaryType.getBinaryType(61, ((BinaryData)this.token.tokenValue).length(null));
                this.token.tokenType = 845;
                return;
            }
            case 66: 
            case 98: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBitString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BitType.getBitType(14, ((BinaryData)this.token.tokenValue).bitLength(null));
                this.token.tokenType = 845;
                return;
            }
            case 78: 
            case 110: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = CharacterType.getCharacterType(1, this.token.tokenString.length());
                this.token.tokenType = 845;
                return;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) != 38 || this.charAt(this.currentPosition + 2) != 39) break;
                this.currentPosition += 2;
                this.token.dataType = Type.SQL_CHAR;
                this.token.tokenType = 845;
                this.scanUnicodeString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = CharacterType.getCharacterType(1, ((String)this.token.tokenValue).length());
                return;
            }
            case 95: {
                ++this.currentPosition;
                this.scanIdentifierChain();
                if (this.token.isMalformed) {
                    return;
                }
                if (this.token.tokenType != 846 || this.token.namePrePrefix != null) {
                    this.token.tokenType = 853;
                    this.token.isMalformed = true;
                    return;
                }
                this.token.charsetSchema = this.token.namePrefix;
                this.token.charsetName = this.token.tokenString;
                this.scanSeparator();
                if (this.charAt(this.currentPosition) != 39) break;
                this.scanCharacterString();
                this.token.tokenType = 845;
                this.token.dataType = CharacterType.getCharacterType(1, this.token.tokenString.length());
                this.token.isDelimiter = true;
                return;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.token.tokenType = 845;
                this.scanNumber();
                return;
            }
        }
        this.scanIdentifierChain();
        if (this.token.tokenType == 846) {
            this.token.isUndelimitedIdentifier = true;
            this.token.tokenType = Tokens.getKeywordID(this.token.tokenString, 846);
            if (this.token.tokenType == 846) {
                this.token.tokenType = Tokens.getNonKeywordID(this.token.tokenString, 846);
            } else {
                this.token.isReservedIdentifier = true;
                this.token.isCoreReservedIdentifier = Tokens.isCoreKeyword(this.token.tokenType);
            }
        } else if (this.token.tokenType == 847) {
            this.token.isDelimitedIdentifier = true;
        }
    }

    public boolean scanNull() {
        this.scanSeparator();
        int character = this.charAt(this.currentPosition);
        return (character == 78 || character == 110) && this.scanSpecialIdentifier("NULL");
    }

    private void scanNext(int error) {
        this.scanNext();
        if (this.token.isMalformed) {
            throw Error.error(error);
        }
    }

    IntervalType scanIntervalType() {
        int endToken;
        int precision = -1;
        int scale = -1;
        int errorCode = 3406;
        int startToken = endToken = this.token.tokenType;
        this.scanNext(3406);
        if (this.token.tokenType == 786) {
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            precision = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType == 774) {
                if (startToken != 250) {
                    throw Error.error(3406);
                }
                this.scanNext(3406);
                if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                    throw Error.error(3406);
                }
                scale = ((Number)this.token.tokenValue).intValue();
                this.scanNext(3406);
            }
            if (this.token.tokenType != 772) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        if (this.token.tokenType == 285) {
            this.scanNext(3406);
            endToken = this.token.tokenType;
            this.scanNext(3406);
        }
        if (this.token.tokenType == 786) {
            if (endToken != 250 || endToken == startToken) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            scale = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType != 772) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        int startIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, startToken);
        int endIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, endToken);
        return IntervalType.getIntervalType(startIndex, endIndex, precision, scale);
    }

    public TimestampData newDate(String s) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = s;
        this.scanDateParts(2);
        if (this.intervalPosition != s.length()) {
            throw Error.error(3407);
        }
        long seconds = HsqlDateTime.getDateSeconds(s);
        return new TimestampData(seconds);
    }

    public TimestampData newTimestamp(String s) {
        long seconds;
        long zoneSeconds = 0L;
        int fraction = 0;
        int endIndex = s.length();
        boolean hasZone = false;
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = s;
        this.scanDateParts(5);
        try {
            seconds = HsqlDateTime.getTimestampSeconds(s.substring(0, this.intervalPosition));
        }
        catch (Throwable e) {
            throw Error.error(3407);
        }
        fraction = this.scanIntervalFraction(9);
        int position = this.intervalPosition;
        boolean negate = this.scanIntervalSign();
        if (negate || position != this.intervalPosition) {
            zoneSeconds = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            hasZone = true;
            if (negate) {
                zoneSeconds = -zoneSeconds;
            }
        }
        if (zoneSeconds >= (long)DTIType.yearToSecondFactors[2] || zoneSeconds > 50400L || -zoneSeconds > 50400L) {
            throw Error.error(3409);
        }
        if (this.intervalPosition != endIndex) {
            throw Error.error(3407);
        }
        int type = hasZone ? 95 : 93;
        this.dateTimeType = DateTimeType.getDateTimeType(type, this.fractionPrecision);
        if (hasZone) {
            seconds -= zoneSeconds;
        }
        return new TimestampData(seconds, fraction, (int)zoneSeconds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void scanDateParts(int lastPart) {
        byte[] separators = DTIType.yearToSecondSeparators;
        int i = this.intervalPosition;
        boolean firstPart = false;
        int currentPart = 0;
        int currentDigits = 0;
        while (currentPart <= lastPart) {
            boolean endOfPart = false;
            if (i == this.intervalString.length()) {
                if (currentPart != lastPart) throw Error.error(3407);
                endOfPart = true;
            } else {
                char character = this.intervalString.charAt(i);
                if (character >= '0' && character <= '9') {
                    ++currentDigits;
                    ++i;
                } else if (character == separators[currentPart]) {
                    endOfPart = true;
                    if (currentPart != lastPart) {
                        ++i;
                    }
                } else {
                    if (currentPart != lastPart) throw Error.error(3407);
                    endOfPart = true;
                }
            }
            if (!endOfPart) continue;
            if (currentPart == 0 ? currentDigits != 4 : currentDigits != 2) {
                throw Error.error(3407);
            }
            ++currentPart;
            currentDigits = 0;
            if (i != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = i;
    }

    public TimeData newTime(String s) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = s;
        long seconds = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_SECOND);
        int fraction = this.scanIntervalFraction(9);
        long zoneSeconds = 0L;
        int position = this.intervalPosition;
        boolean hasZone = false;
        boolean negate = this.scanIntervalSign();
        if (position != this.intervalPosition) {
            zoneSeconds = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            hasZone = true;
        }
        if (this.intervalPosition != s.length()) {
            throw Error.error(3409);
        }
        if (seconds >= (long)DTIType.yearToSecondFactors[2]) {
            throw Error.error(3408);
        }
        if (zoneSeconds > 50400L) {
            throw Error.error(3409);
        }
        if (negate) {
            zoneSeconds = -zoneSeconds;
        }
        int type = hasZone ? 94 : 92;
        this.dateTimeType = DateTimeType.getDateTimeType(type, this.fractionPrecision);
        if (hasZone) {
            seconds -= zoneSeconds;
        }
        return new TimeData((int)seconds, fraction, (int)zoneSeconds);
    }

    public Object newInterval(String s, IntervalType type) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.intervalString = s;
        boolean negate = this.scanIntervalSign();
        long units = this.scanIntervalValue(type);
        int fraction = 0;
        if (type.endIntervalType == 106) {
            fraction = this.scanIntervalFraction(type.scale);
        }
        if (this.intervalPosition != s.length()) {
            throw Error.error(3406);
        }
        if (negate) {
            units = -units;
            fraction = -fraction;
        }
        this.dateTimeType = type;
        if (type.defaultPrecision) {
            this.dateTimeType = IntervalType.getIntervalType(type.typeCode, type.startIntervalType, type.endIntervalType, this.intervalPrecision, this.fractionPrecision, false);
        }
        if (type.endPartIndex <= 1) {
            return new IntervalMonthData(units);
        }
        return new IntervalSecondData(units, fraction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long scanIntervalValue(IntervalType type) {
        byte[] separators = DTIType.yearToSecondSeparators;
        int[] factors = DTIType.yearToSecondFactors;
        int[] limits = DTIType.yearToSecondLimits;
        int firstPart = type.startPartIndex;
        int lastPart = type.endPartIndex;
        long totalValue = 0L;
        int currentValue = 0;
        int i = this.intervalPosition;
        int currentPart = firstPart;
        int currentDigits = 0;
        while (currentPart <= lastPart) {
            boolean endOfPart = false;
            if (i == this.intervalString.length()) {
                if (currentPart != lastPart) throw Error.error(3406);
                endOfPart = true;
            } else {
                char character = this.intervalString.charAt(i);
                if (character >= '0' && character <= '9') {
                    int digit = character - 48;
                    currentValue *= 10;
                    currentValue += digit;
                    ++currentDigits;
                    ++i;
                } else if (character == separators[currentPart]) {
                    endOfPart = true;
                    if (currentPart != lastPart) {
                        ++i;
                    }
                } else {
                    if (currentPart != lastPart) throw Error.error(3406);
                    endOfPart = true;
                }
            }
            if (!endOfPart) continue;
            if (currentPart == firstPart) {
                if (!type.defaultPrecision && (long)currentDigits > type.precision) {
                    throw Error.error(3435);
                }
                if (currentDigits == 0) {
                    throw Error.error(3406);
                }
                int factor = factors[currentPart];
                totalValue += (long)currentValue * (long)factor;
                this.intervalPrecision = currentDigits;
            } else {
                if (currentValue >= limits[currentPart]) {
                    throw Error.error(3435);
                }
                if (currentDigits != 2) {
                    throw Error.error(3406);
                }
                totalValue += (long)(currentValue * factors[currentPart]);
            }
            ++currentPart;
            currentValue = 0;
            currentDigits = 0;
            if (i != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = i;
        return totalValue;
    }

    boolean scanIntervalSign() {
        boolean negate = false;
        if (this.intervalPosition == this.intervalString.length()) {
            return false;
        }
        if (this.intervalString.charAt(this.intervalPosition) == '-') {
            negate = true;
            ++this.intervalPosition;
        } else if (this.intervalString.charAt(this.intervalPosition) == '+') {
            ++this.intervalPosition;
        }
        return negate;
    }

    int scanIntervalFraction(int decimalPrecision) {
        char character;
        if (this.intervalPosition == this.intervalString.length()) {
            return 0;
        }
        if (this.intervalString.charAt(this.intervalPosition) != '.') {
            return 0;
        }
        ++this.intervalPosition;
        int currentValue = 0;
        int currentDigits = 0;
        while (this.intervalPosition < this.intervalString.length() && (character = this.intervalString.charAt(this.intervalPosition)) >= '0' && character <= '9') {
            int digit = character - 48;
            currentValue *= 10;
            currentValue += digit;
            ++this.intervalPosition;
            if (++currentDigits != 9) continue;
            break;
        }
        this.fractionPrecision = currentDigits;
        currentValue *= DTIType.nanoScaleFactors[currentDigits];
        currentValue = DTIType.normaliseFraction(currentValue, decimalPrecision);
        return currentValue;
    }

    void scanIntervalSpaces() {
        while (this.intervalPosition < this.intervalString.length() && this.intervalString.charAt(this.intervalPosition) == ' ') {
            ++this.intervalPosition;
        }
    }

    public synchronized Number convertToNumber(String s, NumberType numberType) {
        boolean minus = false;
        this.reset(s);
        this.resetState();
        this.scanWhitespace();
        this.scanToken();
        this.scanWhitespace();
        if (this.token.tokenType == 787) {
            this.scanToken();
            this.scanWhitespace();
        } else if (this.token.tokenType == 784) {
            minus = true;
            this.scanToken();
            this.scanWhitespace();
        }
        if (!this.hasNonSpaceSeparator && this.token.tokenType == 845 && this.token.tokenValue instanceof Number) {
            Number number = (Number)this.token.tokenValue;
            Type type = this.token.dataType;
            if (minus) {
                number = (Number)this.token.dataType.negate(number);
            }
            this.scanEnd();
            if (this.token.tokenType == 848) {
                number = (Number)numberType.convertToType(null, number, type);
                return number;
            }
        }
        throw Error.error(3438);
    }

    public synchronized BinaryData convertToBinary(String s) {
        boolean hi = true;
        byte b = 0;
        this.reset(s);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            int c = this.sqlString.charAt(this.currentPosition);
            if ((c = Scanner.getHexValue(c)) == -1) {
                this.token.tokenType = 856;
                this.token.isMalformed = true;
                break;
            }
            if (hi) {
                b = (byte)(c << 4);
            } else {
                b = (byte)(b + (byte)c);
                this.byteOutputStream.writeByte(b);
            }
            ++this.currentPosition;
            hi = !hi;
        }
        if (!hi) {
            this.token.tokenType = 856;
            this.token.isMalformed = true;
        }
        if (this.token.isMalformed) {
            throw Error.error(3438);
        }
        BinaryData data = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
        return data;
    }

    public synchronized BinaryData convertToBit(String s) {
        BitMap map = new BitMap(32);
        int bitIndex = map.size();
        this.reset(s);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c == '0') {
                ++bitIndex;
            } else if (c == '1') {
                map.set(bitIndex);
                ++bitIndex;
            } else {
                this.token.tokenType = 855;
                this.token.isMalformed = true;
                throw Error.error(3438);
            }
            ++this.currentPosition;
        }
        map.setSize(bitIndex);
        return BinaryData.getBitData(map.getBytes(), map.size());
    }

    public synchronized Object convertToDatetimeInterval(SessionInterface session, String s, DTIType type) {
        IntervalType intervalType = null;
        int dateTimeToken = -1;
        int errorCode = type.isDateTimeType() ? 3407 : 3406;
        this.reset(s);
        this.resetState();
        this.scanToken();
        this.scanWhitespace();
        switch (this.token.tokenType) {
            case 72: 
            case 140: 
            case 281: 
            case 282: {
                dateTimeToken = this.token.tokenType;
                this.scanToken();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) {
                    throw Error.error(errorCode);
                }
                s = this.token.tokenString;
                this.scanNext(3407);
                if (type.isIntervalType()) {
                    intervalType = this.scanIntervalType();
                }
                if (this.token.tokenType == 848) break;
                throw Error.error(errorCode);
            }
        }
        switch (type.typeCode) {
            case 91: {
                if (dateTimeToken != -1 && dateTimeToken != 72) {
                    throw Error.error(errorCode);
                }
                TimestampData value = this.newDate(s);
                return type.convertToType(session, value, Type.SQL_DATE);
            }
            case 92: 
            case 94: {
                if (dateTimeToken != -1 && dateTimeToken != 281) {
                    throw Error.error(errorCode);
                }
                TimeData o = this.newTime(s);
                return type.convertToType(session, o, this.dateTimeType);
            }
            case 93: 
            case 95: {
                if (dateTimeToken != -1 && dateTimeToken != 282) {
                    throw Error.error(errorCode);
                }
                TimestampData value = this.newTimestamp(s);
                return type.convertToType(session, value, this.dateTimeType);
            }
        }
        if (dateTimeToken != -1 && dateTimeToken != 140) {
            throw Error.error(errorCode);
        }
        if (type.isIntervalType()) {
            Object value = this.newInterval(s, (IntervalType)type);
            if (intervalType != null && (intervalType.startIntervalType != type.startIntervalType || intervalType.endIntervalType != type.endIntervalType)) {
                throw Error.error(errorCode);
            }
            return type.convertToType(session, value, this.dateTimeType);
        }
        throw Error.runtimeError(201, "Scanner");
    }

    static {
        for (int i = 0; i < whitespace.length; ++i) {
            whiteSpaceSet.add(whitespace[i]);
        }
        maxPooledStringLength = ValuePool.getMaxStringLength();
    }
}

