/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.rpc;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCException;
import com.liferay.portal.kernel.process.ProcessCallable;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class IntrabandRPCUtil {
    protected static Callable<Serializable> emptyCallable = new Callable<Serializable>(){

        @Override
        public Serializable call() throws Exception {
            return null;
        }
    };
    protected static EnumSet<CompletionHandler.CompletionType> repliedEnumSet = EnumSet.of(CompletionHandler.CompletionType.REPLIED);

    public static <V extends Serializable> Future<V> execute(RegistrationReference registrationReference, ProcessCallable<V> processCallable) throws IntrabandRPCException {
        Intraband intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.RPC;
        Serializer serializer = new Serializer();
        serializer.writeObject(processCallable);
        try {
            Datagram datagram = Datagram.createRequestDatagram(systemDataType.getValue(), serializer.toByteBuffer());
            FutureResult futureResult = new FutureResult();
            intraband.sendDatagram(registrationReference, datagram, null, repliedEnumSet, new FutureCompletionHandler(futureResult));
            return futureResult;
        }
        catch (Exception e) {
            throw new IntrabandRPCException(e);
        }
    }

    protected static class FutureCompletionHandler<V extends Serializable>
    implements CompletionHandler<Object> {
        private final FutureResult<V> _futureResult;

        protected FutureCompletionHandler(FutureResult<V> futureResult) {
            this._futureResult = futureResult;
        }

        @Override
        public void delivered(Object attachment) {
        }

        @Override
        public void failed(Object attachment, IOException ioe) {
            this._futureResult.setException(ioe);
        }

        @Override
        public void replied(Object attachment, Datagram datagram) {
            Deserializer deserializer = new Deserializer(datagram.getDataByteBuffer());
            try {
                Object v = deserializer.readObject();
                this._futureResult.set(v);
            }
            catch (ClassNotFoundException cnfe) {
                this._futureResult.setException(cnfe);
            }
        }

        @Override
        public void submitted(Object attachment) {
        }

        @Override
        public void timedOut(Object attachment) {
            this._futureResult.cancel(true);
        }
    }

    protected static class FutureResult<V extends Serializable>
    extends FutureTask<V> {
        protected FutureResult() {
            super(emptyCallable);
        }

        @Override
        protected void set(V v) {
            super.set(v);
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
        }
    }
}

