/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.EvalFailureException;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprBoolean;
import com.hp.hpl.jena.rdf.query.parser.ExprNumeric;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExpressions {
    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        TestExpressions.addTests(testSuite);
        return testSuite;
    }

    public static void addTests(TestSuite testSuite) {
        testSuite.addTest((Test)new TestNumeric("7", 7));
        testSuite.addTest((Test)new TestNumeric("-3", -3));
        testSuite.addTest((Test)new TestNumeric("3+4+5", 12));
        testSuite.addTest((Test)new TestNumeric("(3+4)+5", 12));
        testSuite.addTest((Test)new TestNumeric("3+(4+5)", 12));
        testSuite.addTest((Test)new TestNumeric("3*4+5", 17));
        testSuite.addTest((Test)new TestNumeric("3*(4+5)", 27));
        testSuite.addTest((Test)new TestNumeric("10-3-5", 2));
        testSuite.addTest((Test)new TestNumeric("(10-3)-5", 2));
        testSuite.addTest((Test)new TestNumeric("10-(3-5)", 12));
        testSuite.addTest((Test)new TestNumeric("10-3+5", 12));
        testSuite.addTest((Test)new TestNumeric("10-(3+5)", 2));
        testSuite.addTest((Test)new TestNumeric("1<<2", 4));
        testSuite.addTest((Test)new TestNumeric("1<<2<<2", 16));
        testSuite.addTest((Test)new TestNumeric("10000>>2", 2500));
        testSuite.addTest((Test)new TestBoolean("true", false, true));
        testSuite.addTest((Test)new TestBoolean("false", false, false));
        testSuite.addTest((Test)new TestBoolean("false || true", false, true));
        testSuite.addTest((Test)new TestBoolean("false && true", false, false));
        testSuite.addTest((Test)new TestBoolean("2 < 3", false, true));
        testSuite.addTest((Test)new TestBoolean("2 > 3", false, false));
        testSuite.addTest((Test)new TestBoolean("(2 < 3) && (3<4)", false, true));
        testSuite.addTest((Test)new TestBoolean("(2 < 3) && (3>=4)", false, false));
        testSuite.addTest((Test)new TestBoolean("(2 < 3) || (3>=4)", false, true));
        testSuite.addTest((Test)new TestBoolean("2 == 3", false, false));
        testSuite.addTest((Test)new TestBoolean("\"fred\" ne \"joe\"", false, true));
        testSuite.addTest((Test)new TestBoolean("\"fred\" eq \"joe\"", false, false));
        testSuite.addTest((Test)new TestBoolean("\"fred\" eq \"fred\"", false, true));
        testSuite.addTest((Test)new TestBoolean("\"fred\" eq 'fred'", false, true));
        testSuite.addTest((Test)new TestBoolean("\"fred\" eq 'fr\\ed'", false, true));
        testSuite.addTest((Test)new TestBoolean("\"fred\" ne \"fred\"", false, false));
        testSuite.addTest((Test)new TestBoolean("\"fred\\1\" eq 'fred1'", false, true));
        testSuite.addTest((Test)new TestBoolean("\"fred2\" eq 'fred\\2'", false, true));
        testSuite.addTest((Test)new TestBoolean("'fred\\\\3' ne \"fred3\"", false, true));
        testSuite.addTest((Test)new TestBoolean("\"urn:fred\" eq <urn:fred>", false, true));
        testSuite.addTest((Test)new TestBoolean("\"urn:fred\" ne <urn:fred>", false, false));
        testSuite.addTest((Test)new TestBoolean("\"urn:fred/1.5\" ne <urn:fred/1.5>", false, false));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" =~ /abbc/", false, true));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" =~ /a..c/", false, true));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" =~ /^aabb/", false, true));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" =~ /cc$/", false, true));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" !~ /abbc/", false, false));
        testSuite.addTest((Test)new TestBoolean("\"aab*bcc\" =~ /ab\\*bc/", false, true));
        testSuite.addTest((Test)new TestBoolean("\"aabbcc\" ~~ /ab\\\\*bc/", false, true));
        testSuite.addTest((Test)new TestBoolean("'aabbcc' =~ /B.*B/i", false, true));
        testSuite.addTest((Test)new TestBoolean("2 < \"fred\"", true, false));
        testSuite.addTest((Test)new TestBoolean("2 || true", true, false));
    }

    static class TestBoolean
    extends TestCase {
        String s;
        boolean failureCorrect;
        boolean rightAnswer;

        TestBoolean(String string, boolean bl, boolean bl2) {
            super("Boolean test : " + string + " ");
            this.s = string;
            this.failureCorrect = bl;
            this.rightAnswer = bl2;
        }

        protected void runTest() throws Throwable {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser rDQLParser = new RDQLParser(byteArrayInputStream);
            l3 = System.currentTimeMillis();
            try {
                rDQLParser.Expression();
            }
            catch (Error error) {
                Assert.fail((String)("Error throw in parse: " + this.s));
            }
            l4 = System.currentTimeMillis();
            l2 = l4 - l3;
            SimpleNode simpleNode = rDQLParser.top();
            Expr expr = (Expr)((Object)simpleNode);
            Assert.assertTrue((String)("Expression is not ExprBoolean: " + expr.getClass().getName()), (boolean)(expr instanceof ExprBoolean));
            ExprBoolean exprBoolean = (ExprBoolean)expr;
            Value value = null;
            boolean bl = false;
            try {
                value = exprBoolean.eval(null, null);
                bl = value.getBoolean();
            }
            catch (EvalFailureException evalFailureException) {
                if (!this.failureCorrect) {
                    throw evalFailureException;
                }
                bl = false;
            }
            Assert.assertEquals((String)(this.s + " => " + bl + " [" + this.rightAnswer + "]"), (boolean)bl, (boolean)this.rightAnswer);
        }
    }

    static class TestNumeric
    extends TestCase {
        String s;
        int rightAnswer;

        TestNumeric(String string, int n) {
            super("Numeric test : " + string + " ");
            this.s = string;
            this.rightAnswer = n;
        }

        protected void runTest() throws Throwable {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            RDQLParser rDQLParser = new RDQLParser(byteArrayInputStream);
            l3 = System.currentTimeMillis();
            try {
                rDQLParser.Expression();
            }
            catch (Error error) {
                Assert.fail((String)("Error thrown in parse: " + error));
            }
            l4 = System.currentTimeMillis();
            l2 = l4 - l3;
            Expr expr = (Expr)((Object)rDQLParser.top());
            Assert.assertTrue((String)("Expression is not ExprNumeric: " + expr.getClass().getName()), (boolean)(expr instanceof ExprNumeric));
            ExprNumeric exprNumeric = (ExprNumeric)expr;
            Value value = exprNumeric.eval(null, null);
            Assert.assertEquals((String)(this.s + " => " + value.getInt() + " [" + this.rightAnswer + "]"), (int)value.getInt(), (int)this.rightAnswer);
        }
    }
}

