/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.security;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlManager;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlPolicy;
import org.apache.jackrabbit.rmi.remote.security.RemotePrivilege;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerAccessControlManager
extends ServerObject
implements RemoteAccessControlManager {
    private final AccessControlManager acm;

    public ServerAccessControlManager(AccessControlManager acm, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.acm = acm;
    }

    public RemoteIterator getApplicablePolicies(String absPath) throws RepositoryException, RemoteException {
        return this.getFactory().getRemoteAccessControlPolicyIterator(this.acm, this.acm.getApplicablePolicies(absPath));
    }

    public RemoteAccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException, RemoteException {
        return this.getFactory().getRemoteAccessControlPolicy(this.acm, this.acm.getEffectivePolicies(absPath));
    }

    public RemoteAccessControlPolicy[] getPolicies(String absPath) throws RepositoryException, RemoteException {
        return this.getFactory().getRemoteAccessControlPolicy(this.acm, this.acm.getPolicies(absPath));
    }

    public RemotePrivilege[] getPrivileges(String absPath) throws RepositoryException, RemoteException {
        return this.getFactory().getRemotePrivilege(this.acm.getPrivileges(absPath));
    }

    public RemotePrivilege[] getSupportedPrivileges(String absPath) throws RepositoryException, RemoteException {
        return this.getFactory().getRemotePrivilege(this.acm.getSupportedPrivileges(absPath));
    }

    public boolean hasPrivileges(String absPath, String[] privileges) throws RepositoryException {
        Privilege[] privs = new Privilege[privileges.length];
        int i = 0;
        while (i < privs.length) {
            privs[i] = this.acm.privilegeFromName(privileges[i]);
            ++i;
        }
        return this.acm.hasPrivileges(absPath, privs);
    }

    public RemotePrivilege privilegeFromName(String privilegeName) throws RepositoryException, RemoteException {
        return this.getFactory().getRemotePrivilege(this.acm.privilegeFromName(privilegeName));
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException, RemoteException {
        this.acm.setPolicy(absPath, policy);
    }
}

