/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.currencyconverter.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portlet.currencyconverter.model.Currency;
import com.liferay.portlet.currencyconverter.util.CurrencyUtil;
import java.util.StringTokenizer;

public class CurrencyWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 1200000L;
    private String _symbol;

    public CurrencyWebCacheItem(String symbol) {
        this._symbol = symbol;
    }

    public Object convert(String key) throws WebCacheException {
        String symbol = this._symbol;
        double rate = 0.0;
        try {
            if (symbol.length() == 6) {
                String fromSymbol = symbol.substring(0, 3);
                String toSymbol = symbol.substring(3, 6);
                if (!CurrencyUtil.isCurrency(fromSymbol) || !CurrencyUtil.isCurrency(toSymbol)) {
                    throw new WebCacheException(symbol);
                }
            } else if (symbol.length() == 3) {
                if (!CurrencyUtil.isCurrency(symbol)) {
                    throw new WebCacheException(symbol);
                }
            } else {
                throw new WebCacheException(symbol);
            }
            String text = HttpUtil.URLtoString((String)("http://finance.yahoo.com/d/quotes.csv?s=" + symbol + "=X&f=sl1d1t1c1ohgv&e=.csv"));
            StringTokenizer st = new StringTokenizer(text, ",");
            st.nextToken();
            rate = GetterUtil.getDouble((String)st.nextToken().replace('\"', ' ').trim());
        }
        catch (Exception e2) {
            throw new WebCacheException((Throwable)e2);
        }
        return new Currency(symbol, rate);
    }

    public long getRefreshTime() {
        return 1200000L;
    }
}

