/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.index.composites.CompositesIndexIncludingCollectionKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.SetType;

public class CompositesIndexOnCollectionKey
extends CompositesIndexIncludingCollectionKey {
    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        return ((CollectionType)this.columnDef.type).nameComparator();
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.name().get(this.columnDef.position() + 1);
    }

    @Override
    public boolean supportsOperator(Operator operator) {
        return operator == Operator.CONTAINS_KEY || operator == Operator.CONTAINS && this.columnDef.type instanceof SetType;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        CellName name = data.getComparator().create(entry.indexedEntryPrefix, this.columnDef, entry.indexValue.getKey());
        Cell cell = data.getColumn(name);
        return cell == null || !cell.isLive(now);
    }
}

