/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.big.IndexedSliceReader;
import org.apache.cassandra.io.sstable.format.big.SimpleSliceReader;
import org.apache.cassandra.io.util.FileDataInput;

class SSTableSliceIterator
implements OnDiskAtomIterator {
    private final OnDiskAtomIterator reader;
    private final DecoratedKey key;

    public SSTableSliceIterator(SSTableReader sstable, DecoratedKey key, ColumnSlice[] slices, boolean reversed) {
        this.key = key;
        RowIndexEntry indexEntry = sstable.getPosition(key, SSTableReader.Operator.EQ);
        this.reader = indexEntry == null ? null : SSTableSliceIterator.createReader(sstable, indexEntry, null, slices, reversed);
    }

    public SSTableSliceIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, ColumnSlice[] slices, boolean reversed, RowIndexEntry indexEntry) {
        this.key = key;
        this.reader = SSTableSliceIterator.createReader(sstable, indexEntry, file, slices, reversed);
    }

    private static OnDiskAtomIterator createReader(SSTableReader sstable, RowIndexEntry indexEntry, FileDataInput file, ColumnSlice[] slices, boolean reversed) {
        return (OnDiskAtomIterator)(slices.length == 1 && slices[0].start.isEmpty() && !reversed ? new SimpleSliceReader(sstable, indexEntry, file, slices[0].finish) : new IndexedSliceReader(sstable, indexEntry, file, slices, reversed));
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.reader == null ? null : this.reader.getColumnFamily();
    }

    @Override
    public boolean hasNext() {
        return this.reader != null && this.reader.hasNext();
    }

    @Override
    public OnDiskAtom next() {
        return (OnDiskAtom)this.reader.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

