/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Database database;
    int rowIdSequence = 0;

    public RowStoreAVLMemory(PersistentStoreCollection manager, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        manager.setStore(table, this);
    }

    public boolean isMemory() {
        return true;
    }

    public int getAccessCount() {
        return 0;
    }

    public void set(CachedObject object) {
    }

    public CachedObject get(int i) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    public CachedObject get(int i, boolean keep) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    public CachedObject get(CachedObject object, boolean keep) {
        return object;
    }

    public int getStorageSize(int i) {
        return 0;
    }

    public void add(CachedObject object) {
    }

    public CachedObject get(RowInputInterface in) {
        return null;
    }

    public CachedObject getNewInstance(int size) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        int id;
        RowStoreAVLMemory rowStoreAVLMemory = this;
        synchronized (rowStoreAVLMemory) {
            id = this.rowIdSequence++;
        }
        RowAVL row = new RowAVL(this.table, (Object[])object, id, this);
        if (tx) {
            RowAction action;
            row.rowAction = action = new RowAction(session, this.table, 1, row, null);
        }
        return row;
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int i) {
    }

    public void removePersistence(int i) {
    }

    public void release(int i) {
    }

    public void commitPersistence(CachedObject row) {
    }

    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, data);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    public DataFileCache getCache() {
        return null;
    }

    public void setCache(DataFileCache cache) {
    }

    public void release() {
        this.setTimestamp(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    public void setAccessor(Index key, int accessor) {
    }
}

