/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.WikiLogger;

public class TableOfContents {
    private static final WikiLogger logger = WikiLogger.getLogger(TableOfContents.class.getName());
    public static final int STATUS_TOC_UNINITIALIZED = 0;
    public static final int STATUS_TOC_INITIALIZED = 1;
    public static final int STATUS_NO_TOC = 2;
    private boolean forceTOC = false;
    private int insertTagCount = 0;
    private int insertionAttempt = 0;
    private int minLevel = 4;
    private final Map<String, TableOfContentsEntry> entries = new LinkedHashMap<String, TableOfContentsEntry>();
    private int status = 0;
    private static final int MINIMUM_HEADINGS = 4;
    private int[] tocPrefixes = null;

    public void addEntry(String name, String text, int level) {
        if (this.status != 2 && this.status != 1) {
            this.setStatus(1);
        }
        name = this.buildUniqueName(name);
        TableOfContentsEntry entry = new TableOfContentsEntry(name, text, level);
        this.entries.put(name, entry);
        if (level < this.minLevel) {
            this.minLevel = level;
        }
    }

    public String attemptTOCInsertion() {
        ++this.insertionAttempt;
        if (this.size() == 0 || this.size() < 4 && !this.forceTOC) {
            return "";
        }
        if (this.getStatus() == 2) {
            return "";
        }
        if (!Environment.getBooleanValue("allow-toc")) {
            return "";
        }
        if (this.insertionAttempt < this.insertTagCount) {
            return "";
        }
        return this.toHTML();
    }

    public String buildUniqueName(String name) {
        String escapedName;
        if (StringUtils.isBlank((String)name)) {
            name = "empty";
        }
        int count = 0;
        String candidate = escapedName = LinkUtil.buildAnchorText(name);
        while (count < 1000 && this.entries.get(candidate) != null) {
            candidate = escapedName + "_" + ++count;
        }
        return candidate;
    }

    private void closeList(int level, StringBuilder text, int previousLevel) {
        for (int i = previousLevel; i > level; --i) {
            text.append("</li>\n</ul>");
        }
    }

    public int getStatus() {
        return this.status;
    }

    private String nextTocPrefix(int depth) {
        int i;
        int maxDepth = Environment.getIntValue("toc-depth");
        if (this.tocPrefixes == null) {
            this.tocPrefixes = new int[maxDepth];
            for (i = 0; i < maxDepth; ++i) {
                this.tocPrefixes[i] = 0;
            }
        }
        this.tocPrefixes[depth] = this.tocPrefixes[depth] + 1;
        for (i = depth + 1; i < maxDepth; ++i) {
            this.tocPrefixes[i] = 0;
        }
        String prefix = Integer.valueOf(this.tocPrefixes[0]).toString();
        for (int i2 = 1; i2 <= depth; ++i2) {
            prefix = prefix + "." + this.tocPrefixes[i2];
        }
        return prefix;
    }

    private void openList(int level, StringBuilder text, int previousLevel) {
        if (level <= previousLevel) {
            text.append("</li>\n<li>");
            return;
        }
        for (int i = previousLevel; i < level; ++i) {
            text.append("<ul>\n<li>");
        }
    }

    public void setForceTOC(boolean forceTOC) {
        this.forceTOC = forceTOC;
    }

    public void setStatus(int status) {
        if (status == 1) {
            ++this.insertTagCount;
        }
        this.status = status;
    }

    public int size() {
        return this.entries.size();
    }

    public String toHTML() {
        StringBuilder text = new StringBuilder();
        text.append("<table id=\"toc\">\n<tr>\n<td>\n");
        int adjustedLevel = 0;
        int previousLevel = 0;
        for (TableOfContentsEntry entry : this.entries.values()) {
            adjustedLevel = entry.level - this.minLevel + 1;
            if (adjustedLevel > previousLevel + 1) {
                adjustedLevel = previousLevel + 1;
            }
            if (adjustedLevel > Environment.getIntValue("toc-depth")) continue;
            this.closeList(adjustedLevel, text, previousLevel);
            this.openList(adjustedLevel, text, previousLevel);
            text.append("<a href=\"#").append(entry.name).append("\">");
            text.append("<span class=\"tocnumber\">").append(this.nextTocPrefix(adjustedLevel - 1)).append("</span> ");
            text.append("<span class=\"toctext\">").append(entry.text).append("</span></a>");
            previousLevel = adjustedLevel;
        }
        this.closeList(0, text, previousLevel);
        text.append("\n</td>\n</tr>\n</table>\n");
        return text.toString();
    }

    class TableOfContentsEntry {
        int level;
        String name;
        String text;

        TableOfContentsEntry(String name, String text, int level) {
            this.name = name;
            this.text = text;
            this.level = level;
        }
    }
}

