/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ExecuteWithFailover;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolMBeanManager;
import com.netflix.astyanax.connectionpool.impl.SimpleHostConnectionPool;
import com.netflix.astyanax.connectionpool.impl.TokenPartitionedTopology;
import com.netflix.astyanax.connectionpool.impl.Topology;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.retry.RetryPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public abstract class AbstractHostPartitionConnectionPool<CL>
implements ConnectionPool<CL>,
SimpleHostConnectionPool.Listener<CL> {
    protected final NonBlockingHashMap<Host, HostConnectionPool<CL>> hosts;
    protected final ConnectionPoolConfiguration config;
    protected final ConnectionFactory<CL> factory;
    protected final ConnectionPoolMonitor monitor;
    protected final Topology<CL> topology;
    protected final Partitioner partitioner;
    private static Comparator<TokenRange> compareByStartToken = new Comparator<TokenRange>(){

        @Override
        public int compare(TokenRange p1, TokenRange p2) {
            return p1.getStartToken().compareTo(p2.getStartToken());
        }
    };

    public AbstractHostPartitionConnectionPool(ConnectionPoolConfiguration config, ConnectionFactory<CL> factory, ConnectionPoolMonitor monitor) {
        this.config = config;
        this.factory = factory;
        this.monitor = monitor;
        this.hosts = new NonBlockingHashMap();
        this.topology = new TokenPartitionedTopology(config.getPartitioner(), config.getLatencyScoreStrategy());
        this.partitioner = config.getPartitioner();
    }

    @Override
    public void start() {
        ConnectionPoolMBeanManager.getInstance().registerMonitor(this.config.getName(), this);
        String seeds = this.config.getSeeds();
        if (seeds != null && !seeds.isEmpty()) {
            this.setHosts(this.config.getSeedHosts());
        }
        this.config.getLatencyScoreStrategy().start(new LatencyScoreStrategy.Listener(){

            @Override
            public void onUpdate() {
                AbstractHostPartitionConnectionPool.this.rebuildPartitions();
            }

            @Override
            public void onReset() {
                AbstractHostPartitionConnectionPool.this.rebuildPartitions();
            }
        });
    }

    @Override
    public void shutdown() {
        ConnectionPoolMBeanManager.getInstance().unregisterMonitor(this.config.getName(), this);
        for (Map.Entry pool : this.hosts.entrySet()) {
            ((HostConnectionPool)pool.getValue()).shutdown();
        }
        this.config.getLatencyScoreStrategy().shutdown();
        this.config.shutdown();
    }

    protected HostConnectionPool<CL> newHostConnectionPool(Host host, ConnectionFactory<CL> factory, ConnectionPoolConfiguration config) {
        return new SimpleHostConnectionPool<CL>(host, factory, this.monitor, config, this);
    }

    @Override
    public void onHostDown(HostConnectionPool<CL> pool) {
        this.topology.suspendPool(pool);
    }

    @Override
    public void onHostUp(HostConnectionPool<CL> pool) {
        this.topology.resumePool(pool);
    }

    @Override
    public final synchronized boolean addHost(Host host, boolean refresh) {
        if (this.hosts.containsKey((Object)host)) {
            Host existingHost = ((HostConnectionPool)this.hosts.get((Object)host)).getHost();
            if (existingHost.getTokenRanges().size() != host.getTokenRanges().size()) {
                existingHost.setTokenRanges(host.getTokenRanges());
                return true;
            }
            ArrayList currentTokens = Lists.newArrayList(existingHost.getTokenRanges());
            ArrayList newTokens = Lists.newArrayList(host.getTokenRanges());
            Collections.sort(currentTokens, compareByStartToken);
            Collections.sort(newTokens, compareByStartToken);
            for (int i = 0; i < currentTokens.size(); ++i) {
                if (((TokenRange)currentTokens.get(i)).getStartToken().equals(((TokenRange)newTokens.get(i)).getStartToken()) && ((TokenRange)currentTokens.get(i)).getEndToken().equals(((TokenRange)newTokens.get(i)).getEndToken())) continue;
                return false;
            }
            existingHost.setTokenRanges(host.getTokenRanges());
            return true;
        }
        HostConnectionPool<CL> pool = this.newHostConnectionPool(host, this.factory, this.config);
        if (null == this.hosts.putIfAbsent((Object)host, pool)) {
            try {
                this.monitor.onHostAdded(host, pool);
                if (refresh) {
                    this.topology.addPool(pool);
                    this.rebuildPartitions();
                }
                pool.primeConnections(this.config.getInitConnsPerHost());
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isHostUp(Host host) {
        HostConnectionPool pool = (HostConnectionPool)this.hosts.get((Object)host);
        if (pool != null) {
            return !pool.isReconnecting();
        }
        return false;
    }

    @Override
    public boolean hasHost(Host host) {
        return this.hosts.containsKey((Object)host);
    }

    @Override
    public List<HostConnectionPool<CL>> getActivePools() {
        return ImmutableList.copyOf(this.topology.getAllPools().getPools());
    }

    @Override
    public List<HostConnectionPool<CL>> getPools() {
        return ImmutableList.copyOf((Collection)this.hosts.values());
    }

    @Override
    public synchronized boolean removeHost(Host host, boolean refresh) {
        HostConnectionPool pool = (HostConnectionPool)this.hosts.remove((Object)host);
        if (pool != null) {
            this.topology.removePool(pool);
            this.rebuildPartitions();
            this.monitor.onHostRemoved(host);
            pool.shutdown();
            return true;
        }
        return false;
    }

    @Override
    public HostConnectionPool<CL> getHostPool(Host host) {
        return (HostConnectionPool)this.hosts.get((Object)host);
    }

    @Override
    public synchronized void setHosts(Collection<Host> ring) {
        HashSet hostsToRemove = Sets.newHashSet((Iterable)this.hosts.keySet());
        boolean changed = false;
        for (Host host : ring) {
            if (this.addHost(host, false)) {
                changed = true;
            }
            hostsToRemove.remove(host);
        }
        for (Host host : hostsToRemove) {
            this.removeHost(host, false);
            changed = true;
        }
        if (changed) {
            this.topology.setPools(this.hosts.values());
            this.rebuildPartitions();
        }
    }

    @Override
    public <R> OperationResult<R> executeWithFailover(Operation<CL, R> op, RetryPolicy retry) throws ConnectionException {
        retry.begin();
        ConnectionException lastException = null;
        while (true) {
            try {
                OperationResult<R> result = this.newExecuteWithFailover(op).tryOperation(op);
                retry.success();
                return result;
            }
            catch (OperationException e) {
                retry.failure(e);
                throw e;
            }
            catch (ConnectionException e) {
                lastException = e;
                if (retry.allowRetry()) continue;
                retry.failure(lastException);
                throw lastException;
            }
            break;
        }
    }

    protected abstract <R> ExecuteWithFailover<CL, R> newExecuteWithFailover(Operation<CL, R> var1) throws ConnectionException;

    protected void rebuildPartitions() {
        this.topology.refresh();
    }

    @Override
    public Topology<CL> getTopology() {
        return this.topology;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }
}

