/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocaleTransformerListener
extends BaseTransformerListener {
    private static Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);

    public String onScript(String script, String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return StringUtil.replace((String)script, (String)"@language_id@", (String)languageId);
    }

    public String onXml(String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        xml = this.filterByLocalizability(xml, tokens);
        return this.filterByLanguage(xml, languageId);
    }

    protected void filter(Element dynamicElementElement, DDMStructure ddmStructure, String name, String defaultLanguageId) throws PortalException, SystemException {
        boolean localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(name, "localizable"), (boolean)true);
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            String languageId = dynamicContentElement.attributeValue("language-id", defaultLanguageId);
            if (localizable || languageId.equals(defaultLanguageId)) continue;
            dynamicElementElement.remove(dynamicContentElement);
        }
    }

    protected void filterByLanguage(Element root, String languageId, String defaultLanguageId) {
        Element defaultLanguageElement = null;
        boolean hasLanguageIdElement = false;
        for (Element element : root.elements()) {
            String tempLanguageId = element.attributeValue("language-id", languageId);
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)languageId)) {
                hasLanguageIdElement = true;
                this.filterByLanguage(element, languageId, defaultLanguageId);
                continue;
            }
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)defaultLanguageId)) {
                defaultLanguageElement = element;
            }
            root.remove(element);
        }
        if (!hasLanguageIdElement && defaultLanguageElement != null) {
            root.add(defaultLanguageElement);
            this.filterByLanguage(defaultLanguageElement, languageId, defaultLanguageId);
        }
    }

    protected String filterByLanguage(String xml, String languageId) {
        if (xml == null) {
            return xml;
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            Object[] availableLanguageIds = StringUtil.split((String)rootElement.attributeValue("available-locales", defaultLanguageId));
            String articleDefaultLanguageId = rootElement.attributeValue("default-locale", defaultLanguageId);
            if (!ArrayUtil.contains((Object[])availableLanguageIds, (Object)languageId)) {
                this.filterByLanguage(rootElement, articleDefaultLanguageId, defaultLanguageId);
            } else {
                this.filterByLanguage(rootElement, languageId, defaultLanguageId);
            }
            xml = DDMXMLUtil.formatXML((Document)document);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return xml;
    }

    protected String filterByLocalizability(String xml, Map<String, String> tokens) {
        if (xml == null || tokens == null) {
            return xml;
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            long groupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
            long classNameId = ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class);
            String ddmStructureKey = tokens.get("structure_id");
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)ddmStructureKey, (boolean)true);
            if (ddmStructure == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Not checking localization because dynamic data mapping structure is not available");
                }
                return xml;
            }
            Element rootElement = document.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            String articleDefaultLanguageId = rootElement.attributeValue("default-locale", defaultLanguageId);
            this.filterByLocalizability(rootElement, articleDefaultLanguageId, ddmStructure);
            xml = DDMXMLUtil.formatXML((Document)document);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return xml;
    }

    protected void filterByLocalizability(Element root, String defaultLanguageId, DDMStructure ddmStructure) throws PortalException, SystemException {
        for (Element element : root.elements("dynamic-element")) {
            String name = element.attributeValue("name");
            if (!ddmStructure.hasField(name)) continue;
            if (!ddmStructure.isFieldTransient(name)) {
                this.filter(element, ddmStructure, name, defaultLanguageId);
            }
            this.filterByLocalizability(element, defaultLanguageId, ddmStructure);
        }
    }
}

