/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeResource {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResource.class);
    protected static ScopedPublisher scopedPublisher = null;
    protected static DiscoveryClient<ServiceEndpoint> client = null;
    ASLSession session;

    public RuntimeResource(String extrenalSessionID, String username) {
        this.session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
        try {
            ScopeProvider.instance.set(this.session.getScope());
            scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (client == null) {
            try {
                client = ICFactory.clientFor(ServiceEndpoint.class);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                client = null;
            }
        }
    }

    public RuntimeResource(ASLSession session) {
        this.session = session;
        try {
            ScopeProvider.instance.set(session.getScope());
            scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (client == null) {
            try {
                client = ICFactory.clientFor(ServiceEndpoint.class);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                client = null;
            }
        }
    }

    public String createRuntimeResource(ServiceEndpoint runtimeResource) throws RegistryNotFoundException {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(this.session.getScope());
        ServiceEndpoint se = (ServiceEndpoint)scopedPublisher.create((Resource)runtimeResource, scopes);
        logger.debug("Created Runtime Resource with id: " + se.id() + " on scope: " + ((Object)scopes).toString());
        return se.id();
    }

    public String updateRuntimeResource(ServiceEndpoint runtimeResource) throws RemoteException {
        try {
            ServiceEndpoint se = (ServiceEndpoint)scopedPublisher.update((Resource)runtimeResource);
            logger.debug("Updated Runtime Resource with id: " + runtimeResource.id() + "\tNew id : " + se.id());
            return se.id();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    public String deleteRuntimeResource(ServiceEndpoint runtimeResource) throws RemoteException {
        try {
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add(this.session.getScope());
            ServiceEndpoint se = (ServiceEndpoint)scopedPublisher.remove((Resource)runtimeResource, scopes);
            logger.debug("Deleted Runtime Resource with id: " + runtimeResource.id());
            return se.id();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    public List<ServiceEndpoint> getRuntimeResourceByName(String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name eq '" + name + "'");
        List resources = client.submit((Query)query);
        return resources;
    }

    public List<ServiceEndpoint> getRuntimeResourceById(String id) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        query.addCondition("$resource/ID eq '" + id + "'");
        List resources = client.submit((Query)query);
        return resources;
    }

    public List<ServiceEndpoint> getRuntimeResourceByCategory(String category) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category eq '" + category + "'");
        List resources = client.submit((Query)query);
        return resources;
    }
}

