/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import jodd.Jodd;
import jodd.bean.BeanException;
import jodd.bean.loader.BeanLoader;
import jodd.bean.loader.MapBeanLoader;
import jodd.bean.loader.ResultSetBeanLoader;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;

public class BeanLoaderManager {
    protected static final Map<Class, BeanLoader> loaders = new HashMap<Class, BeanLoader>();

    public static void unregisterAll() {
        loaders.clear();
    }

    public static void registerDefaults() {
        BeanLoaderManager.register(Map.class, new MapBeanLoader());
        BeanLoaderManager.register(ResultSet.class, new ResultSetBeanLoader());
        if (Jodd.isServletLoaded()) {
            try {
                Class loaderAddon = ClassLoaderUtil.loadClass("jodd.bean.loader.ServletBeanLoaderManagerAddon");
                ReflectUtil.invoke(loaderAddon, "registerDefaults", null);
            }
            catch (Exception ex) {
                throw new BeanException(ex);
            }
        }
    }

    public static void register(Class type, BeanLoader load) {
        loaders.put(type, load);
    }

    public static void unregister(Class type) {
        loaders.remove(type);
    }

    public static BeanLoader lookup(Class type) {
        return loaders.get(type);
    }

    public static BeanLoader lookup(Object source) {
        BeanLoader load = BeanLoaderManager.lookup(source.getClass());
        if (load == null) {
            for (Class key : loaders.keySet()) {
                if (!key.isInstance(source)) continue;
                load = BeanLoaderManager.lookup(key);
                break;
            }
        }
        return load;
    }

    public static void load(Object bean, Object source) {
        BeanLoader loader = BeanLoaderManager.lookup(source);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + source.getClass().getName());
        }
        loader.load(bean, source);
    }

    public static void load(Object bean, Object source, Class type) {
        BeanLoader loader = BeanLoaderManager.lookup(type);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + type.getName());
        }
        loader.load(bean, source);
    }

    static {
        BeanLoaderManager.registerDefaults();
    }
}

