/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jodd.petite.PetiteException;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetInjectionPoint<T> {
    public static final SetInjectionPoint[] EMPTY = new SetInjectionPoint[0];
    public final Field field;
    public final Class<T> type;
    public final Class targetClass;

    public SetInjectionPoint(Field field) {
        this.field = field;
        this.type = this.resolveSetType(field);
        this.targetClass = ReflectUtil.getComponentType(field.getGenericType());
        if (this.targetClass == null) {
            throw new PetiteException("Unknown Petite set component type " + field.getDeclaringClass().getSimpleName() + '.' + field.getName());
        }
    }

    protected Class<T> resolveSetType(Field field) {
        Class<?> type = field.getType();
        if (type == Collection.class || type == Set.class || type == HashSet.class) {
            return type;
        }
        throw new PetiteException("Unsupported Petite set type: " + type.getName());
    }

    public Collection<T> createSet(int length) {
        return new HashSet(length);
    }
}

