/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.persistence.ImageActionableDynamicQuery;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.store.AdvancedFileSystemStore;
import com.liferay.portlet.documentlibrary.store.CMISStore;
import com.liferay.portlet.documentlibrary.store.DBStore;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.store.JCRStore;
import com.liferay.portlet.documentlibrary.store.S3Store;
import com.liferay.portlet.documentlibrary.store.Store;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageActionableDynamicQuery;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiPageActionableDynamicQuery;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;

public class ConvertDocumentLibrary
extends ConvertProcess {
    private static final String[] _HOOKS = new String[]{AdvancedFileSystemStore.class.getName(), CMISStore.class.getName(), DBStore.class.getName(), FileSystemStore.class.getName(), JCRStore.class.getName(), S3Store.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ConvertDocumentLibrary.class);
    private Store _sourceStore;
    private Store _targetStore;

    @Override
    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    @Override
    public String[] getParameterNames() {
        StringBundler sb = new StringBundler(_HOOKS.length * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        String[] stringArray = _HOOKS;
        int n = _HOOKS.length;
        int n2 = 0;
        while (n2 < n) {
            String hook = stringArray[n2];
            if (!hook.equals(PropsValues.DL_STORE_IMPL)) {
                sb.append(hook);
                sb.append(";");
            }
            ++n2;
        }
        return new String[]{sb.toString(), "delete-files-from-previous-repository=checkbox"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doConvert() throws Exception {
        this._sourceStore = StoreFactory.getInstance();
        String[] values = this.getParameterValues();
        String targetStoreClassName = values[0];
        this._targetStore = (Store)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)targetStoreClassName);
        this.migratePortlets();
        StoreFactory.setInstance(this._targetStore);
        MaintenanceUtil.appendStatus("Please set dl.store.impl in your portal-ext.properties to use " + targetStoreClassName);
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<DLFileVersion> getDLFileVersions(DLFileEntry dlFileEntry) throws SystemException {
        List dlFileVersions = dlFileEntry.getFileVersions(-1);
        return ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator(true));
    }

    protected boolean isDeleteFilesFromSourceStore() {
        String[] values = this.getParameterValues();
        return GetterUtil.getBoolean((String)values[1]);
    }

    protected void migrateDL() throws PortalException, SystemException {
        int count = DLFileEntryLocalServiceUtil.getFileEntriesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " documents and media files");
        DLFileEntryActionableDynamicQuery actionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            }

            protected void performAction(Object object) throws SystemException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                ConvertDocumentLibrary.this.migrateDLFileEntry(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry);
            }
        };
        actionableDynamicQuery.performActions();
        if (this.isDeleteFilesFromSourceStore()) {
            DLPreviewableProcessor.deleteFiles();
        }
    }

    protected void migrateDLFileEntry(long companyId, long repositoryId, DLFileEntry dlFileEntry) throws SystemException {
        String fileName = dlFileEntry.getName();
        List<DLFileVersion> dlFileVersions = this.getDLFileVersions(dlFileEntry);
        if (dlFileVersions.isEmpty()) {
            String versionNumber = "1.0";
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
            return;
        }
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            String versionNumber = dlFileVersion.getVersion();
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
        }
    }

    protected void migrateFile(long companyId, long repositoryId, String fileName, String versionNumber) {
        try {
            InputStream is = this._sourceStore.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            if (versionNumber.equals("1.0")) {
                this._targetStore.addFile(companyId, repositoryId, fileName, is);
            } else {
                this._targetStore.updateFile(companyId, repositoryId, fileName, versionNumber, is);
            }
            if (this.isDeleteFilesFromSourceStore()) {
                this._sourceStore.deleteFile(companyId, repositoryId, fileName, versionNumber);
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Migration failed for " + fileName), (Throwable)e2);
        }
    }

    protected void migrateImages() throws PortalException, SystemException {
        int count = ImageLocalServiceUtil.getImagesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " images");
        ImageActionableDynamicQuery actionableDynamicQuery = new ImageActionableDynamicQuery(){

            protected void performAction(Object object) {
                Image image = (Image)object;
                String fileName = String.valueOf(image.getImageId()) + "." + image.getType();
                ConvertDocumentLibrary.this.migrateFile(0L, 0L, fileName, "1.0");
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void migrateMB() throws PortalException, SystemException {
        int count = MBMessageLocalServiceUtil.getMBMessagesCount();
        MaintenanceUtil.appendStatus("Migrating message boards attachments in " + count + " messages");
        MBMessageActionableDynamicQuery actionableDynamicQuery = new MBMessageActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                MBMessage mbMessage = (MBMessage)object;
                for (FileEntry fileEntry : mbMessage.getAttachmentsFileEntries()) {
                    DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                    ConvertDocumentLibrary.this.migrateDLFileEntry(mbMessage.getCompanyId(), DLFolderConstants.getDataRepositoryId((long)dlFileEntry.getRepositoryId(), (long)dlFileEntry.getFolderId()), dlFileEntry);
                }
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void migratePortlets() throws Exception {
        this.migrateImages();
        this.migrateDL();
        this.migrateMB();
        this.migrateWiki();
    }

    protected void migrateWiki() throws PortalException, SystemException {
        int count = WikiPageLocalServiceUtil.getWikiPagesCount();
        MaintenanceUtil.appendStatus("Migrating wiki page attachments in " + count + " pages");
        WikiPageActionableDynamicQuery actionableDynamicQuery = new WikiPageActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(property.eq((Object)true));
            }

            protected void performAction(Object object) throws SystemException {
                WikiPage wikiPage = (WikiPage)object;
                for (FileEntry fileEntry : wikiPage.getAttachmentsFileEntries()) {
                    DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                    ConvertDocumentLibrary.this.migrateDLFileEntry(wikiPage.getCompanyId(), DLFolderConstants.getDataRepositoryId((long)dlFileEntry.getRepositoryId(), (long)dlFileEntry.getFolderId()), dlFileEntry);
                }
            }
        };
        actionableDynamicQuery.performActions();
    }
}

