/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicatedMap<K, V>
extends AbstractReplicatedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog(ReplicatedMap.class);

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, float loadFactor, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, loadFactor, 2, cls, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, 0.75f, 2, cls, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, 16, 0.75f, 2, cls, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, ClassLoader[] cls, boolean terminate) {
        super(owner, channel, timeout, mapContextName, 16, 0.75f, 2, cls, terminate);
    }

    @Override
    protected int getStateMessageType() {
        return 10;
    }

    @Override
    protected int getReplicateMessageType() {
        return 9;
    }

    @Override
    protected Member[] publishEntryInfo(Object key, Object value) throws ChannelException {
        if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
            return new Member[0];
        }
        Member[] backup = this.getMapMembers();
        if (backup == null || backup.length == 0) {
            return null;
        }
        AbstractReplicatedMap.MapMessage msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 9, false, (Serializable)key, (Serializable)value, null, this.channel.getLocalMember(false), backup);
        this.getChannel().send(this.getMapMembers(), msg, this.getChannelSendOptions());
        return backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        boolean removed = false;
        HashMap hashMap = this.mapMembers;
        synchronized (hashMap) {
            boolean bl = removed = this.mapMembers.remove(member) != null;
            if (!removed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Member[" + member + "] disappeared, but was not present in the map."));
                }
                return;
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Member[" + member + "] disappeared. Related map entries will be relocated to the new node."));
        }
        long start = System.currentTimeMillis();
        for (Map.Entry e : this.innerMap.entrySet()) {
            AbstractReplicatedMap.MapMessage msg;
            Member[] backup;
            AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)this.innerMap.get(e.getKey());
            if (entry == null) continue;
            if (entry.isPrimary()) {
                try {
                    backup = this.getMapMembers();
                    if (backup.length > 0) {
                        msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 12, false, (Serializable)entry.getKey(), null, null, this.channel.getLocalMember(false), backup);
                        this.getChannel().send(backup, msg, this.getChannelSendOptions());
                    }
                    entry.setBackupNodes(backup);
                    entry.setPrimary(this.channel.getLocalMember(false));
                }
                catch (ChannelException x) {
                    this.log.error((Object)("Unable to relocate[" + entry.getKey() + "] to a new backup node"), (Throwable)x);
                }
            } else if (member.equals(entry.getPrimary())) {
                entry.setPrimary(null);
            }
            if (entry.getPrimary() != null || !entry.isCopy() || entry.getBackupNodes() == null || entry.getBackupNodes().length <= 0 || !entry.getBackupNodes()[0].equals(this.channel.getLocalMember(false))) continue;
            try {
                entry.setPrimary(this.channel.getLocalMember(false));
                entry.setBackup(false);
                entry.setProxy(false);
                entry.setCopy(false);
                backup = this.getMapMembers();
                if (backup.length > 0) {
                    msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 12, false, (Serializable)entry.getKey(), null, null, this.channel.getLocalMember(false), backup);
                    this.getChannel().send(backup, msg, this.getChannelSendOptions());
                }
                entry.setBackupNodes(backup);
                if (this.mapOwner == null) continue;
                this.mapOwner.objectMadePrimay(entry.getKey(), entry.getValue());
            }
            catch (ChannelException x) {
                this.log.error((Object)("Unable to relocate[" + entry.getKey() + "] to a new backup node"), (Throwable)x);
            }
        }
        long complete = System.currentTimeMillis() - start;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Relocation of map entries was complete in " + complete + " ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapMemberAdded(Member member) {
        if (member.equals(this.getChannel().getLocalMember(false))) {
            return;
        }
        boolean memberAdded = false;
        Object object = this.mapMembers;
        synchronized (object) {
            if (!this.mapMembers.containsKey(member)) {
                this.mapMembers.put(member, new Long(System.currentTimeMillis()));
                memberAdded = true;
            }
        }
        if (memberAdded) {
            object = this.stateMutex;
            synchronized (object) {
                Member[] backup = this.getMapMembers();
                for (Map.Entry e : this.innerMap.entrySet()) {
                    AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)this.innerMap.get(e.getKey());
                    if (entry == null || !entry.isPrimary() || this.inSet(member, entry.getBackupNodes())) continue;
                    entry.setBackupNodes(backup);
                }
            }
        }
    }
}

