/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.Session;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.types.Type;

class StatementPortal {
    public Object[] parameters;
    public Result bindResult;
    public Result ackResult;
    public String lcQuery;
    public String handle;
    private Map containingMap;
    private Session session;

    public StatementPortal(String handle, OdbcPreparedStatement odbcPs, Map containingMap) throws RecoverableOdbcFailure {
        this(handle, odbcPs, new Object[0], containingMap);
    }

    public StatementPortal(String handle, OdbcPreparedStatement odbcPs, Object[] paramObjs, Map containingMap) throws RecoverableOdbcFailure {
        this.handle = handle;
        this.lcQuery = odbcPs.query.toLowerCase();
        this.ackResult = odbcPs.ackResult;
        this.session = odbcPs.session;
        this.containingMap = containingMap;
        this.bindResult = Result.newPreparedExecuteRequest(odbcPs.ackResult.parameterMetaData.getParameterTypes(), odbcPs.ackResult.getStatementID());
        switch (this.bindResult.getType()) {
            case 35: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(this.bindResult);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from seconary Statement prep is of unexpected type: " + this.bindResult.getType());
            }
        }
        if (paramObjs.length < 1) {
            this.parameters = new Object[0];
        } else {
            ResultMetaData pmd = odbcPs.ackResult.parameterMetaData;
            if (pmd == null) {
                throw new RecoverableOdbcFailure("No metadata for Result ack");
            }
            Type[] paramTypes = pmd.getParameterTypes();
            if (paramTypes.length != paramObjs.length) {
                throw new RecoverableOdbcFailure(null, "Client didn't specify all " + paramTypes.length + " parameters (" + paramObjs.length + ')', "08P01");
            }
            this.parameters = new Object[paramObjs.length];
            try {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i] = paramObjs[i] instanceof String ? PgType.getPgType(paramTypes[i], true).getParameter((String)paramObjs[i], this.session) : paramObjs[i];
                }
            }
            catch (SQLException se) {
                throw new RecoverableOdbcFailure("Typing failure: " + se);
            }
        }
        containingMap.put(handle, this);
    }

    public void close() {
        this.containingMap.remove(this.handle);
    }
}

