/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aspectj;

import com.liferay.portal.aspectj.URLWeavingAdaptor;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.aspectj.bridge.AbortException;

public class WeavingClassLoader
extends URLClassLoader {
    private static Log _log = LogFactoryUtil.getLog(WeavingClassLoader.class);
    private File _dumpDir;
    private URLWeavingAdaptor _urlWeavingAdaptor;

    public WeavingClassLoader(URL[] urls, Class<?>[] aspectClasses, File dumpDir) {
        super(urls, (ClassLoader)null);
        this._dumpDir = dumpDir;
        this._urlWeavingAdaptor = new URLWeavingAdaptor(urls, aspectClasses);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourcePath = String.valueOf(name.replace('.', '/')) + ".class";
        InputStream inputStream = this.getResourceAsStream(resourcePath);
        byte[] data = null;
        try {
            byte[] oldData;
            block12: {
                if (inputStream == null) {
                    data = this._urlWeavingAdaptor.removeGeneratedClassDate(name);
                } else {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (boolean)true);
                    data = unsyncByteArrayOutputStream.toByteArray();
                }
                if (data == null) {
                    throw new ClassNotFoundException(name);
                }
                oldData = data;
                try {
                    data = this._urlWeavingAdaptor.weaveClass(name, data, false);
                }
                catch (AbortException ae) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)("Abort weaving class " + name), (Throwable)ae);
                }
            }
            if (Arrays.equals(oldData, data)) {
                return this._generateClass(name, data);
            }
            if (this._dumpDir != null) {
                File dumpFile = new File(this._dumpDir, resourcePath);
                File dumpDir = dumpFile.getParentFile();
                dumpDir.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(dumpFile);
                fileOutputStream.write(data);
                fileOutputStream.close();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Woven class " + name + " result in " + dumpFile.getCanonicalPath()));
                }
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Woven class " + name));
            }
            return this._generateClass(name, data);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
    }

    private Class<?> _generateClass(String name, byte[] data) {
        Package pkg;
        Class<?> clazz = this.defineClass(name, data, 0, data.length, (ProtectionDomain)null);
        String packageName = null;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            packageName = name.substring(0, index);
        }
        if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return clazz;
    }
}

