/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.DuplicateVocabularyException;
import com.liferay.portlet.asset.VocabularyNameException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetVocabularyLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyLocalServiceImpl
extends AssetVocabularyLocalServiceBaseImpl {
    public AssetVocabulary addDefaultVocabulary(long groupId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(LocaleUtil.getSiteDefault(), PropsValues.ASSET_VOCABULARY_DEFAULT);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        return this.addVocabulary(defaultUserId, "", titleMap, null, "", serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addVocabulary(userId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        Date now = new Date();
        this.validate(groupId, name);
        long vocabularyId = this.counterLocalService.increment();
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
        vocabulary.setUuid(serviceContext.getUuid());
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setCreateDate(now);
        vocabulary.setModifiedDate(now);
        vocabulary.setName(name);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        } else {
            vocabulary.setTitleMap(titleMap);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        indexer.reindex((Object)vocabulary);
        return vocabulary;
    }

    public AssetVocabulary addVocabulary(long userId, String title, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        return this.addVocabulary(userId, title, titleMap, descriptionMap, null, serviceContext);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), groupPermissions, guestPermissions);
    }

    public void deleteVocabularies(long groupId) throws PortalException, SystemException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.deleteVocabulary(vocabulary);
        }
    }

    public void deleteVocabulary(AssetVocabulary vocabulary) throws PortalException, SystemException {
        this.assetVocabularyPersistence.remove((BaseModel)vocabulary);
        this.resourceLocalService.deleteResource(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this.assetCategoryLocalService.deleteVocabularyCategories(vocabulary.getVocabularyId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        indexer.delete((Object)vocabulary);
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.deleteVocabulary(vocabulary);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws SystemException {
        return this.assetVocabularyPersistence.findByCompanyId(companyId);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) throws PortalException, SystemException {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) throws PortalException, SystemException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        long[] lArray = groupIds = ArrayUtil.unique((long[])groupIds);
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            List<AssetVocabulary> groupVocabularies = this.getGroupVocabularies(groupId);
            if (Validator.isNull((String)className)) {
                vocabularies.addAll(groupVocabularies);
            } else {
                for (AssetVocabulary groupVocabulary : groupVocabularies) {
                    UnicodeProperties settingsProperties = groupVocabulary.getSettingsProperties();
                    long[] selectedClassNameIds = StringUtil.split((String)settingsProperties.getProperty("selectedClassNameIds"), (long)0L);
                    long classNameId = PortalUtil.getClassNameId((String)className);
                    if (selectedClassNameIds.length != 0 && selectedClassNameIds[0] != 0L && !ArrayUtil.contains((long[])selectedClassNameIds, (long)classNameId)) continue;
                    vocabularies.add(groupVocabulary);
                }
            }
            ++n2;
        }
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException, SystemException {
        return this.getGroupVocabularies(groupId, true);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean addDefaultVocabulary) throws PortalException, SystemException {
        ArrayList<AssetVocabulary> vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        if (!vocabularies.isEmpty() || !addDefaultVocabulary) {
            return vocabularies;
        }
        AssetVocabulary vocabulary = this.addDefaultVocabulary(groupId);
        vocabularies = new ArrayList<AssetVocabulary>();
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.assetVocabularyFinder.findByG_N(groupId, name, start, end, obc);
    }

    public AssetVocabulary getGroupVocabulary(long groupId, String name) throws PortalException, SystemException {
        return this.assetVocabularyPersistence.findByG_N(groupId, name);
    }

    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException, SystemException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        long[] lArray = vocabularyIds;
        int n = vocabularyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long vocabularyId = lArray[n2];
            AssetVocabulary vocabulary = this.getVocabulary(vocabularyId);
            vocabularies.add(vocabulary);
            ++n2;
        }
        return vocabularies;
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        return this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateVocabulary(vocabularyId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        if (!vocabulary.getName().equals(name)) {
            this.validate(groupId, name);
        }
        vocabulary.setModifiedDate(new Date());
        vocabulary.setName(name);
        vocabulary.setTitleMap(titleMap);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        indexer.reindex((Object)vocabulary);
        return vocabulary;
    }

    protected boolean hasVocabulary(long groupId, String name) throws SystemException {
        return this.assetVocabularyPersistence.countByG_N(groupId, name) != 0;
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new VocabularyNameException();
        }
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A category vocabulary with the name " + name + " already exists");
        }
    }
}

