/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.urlshortener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlShortener {
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String LONG_DYNAMIC_LINK = "longDynamicLink";
    protected static final String SHORTENER = "HTTP-URL-Shortener-DL";
    protected static final String KEY = "key";
    protected static final String DYNAMIC_LINK = "dynamic-link";
    protected static final String SUFFIX = "suffix";
    private static String shortnerServiceUrl = null;
    private static String decryptedKEY = null;
    private static String suffixOption = null;
    private static String dynamicLink = null;
    protected static Logger logger = LoggerFactory.getLogger(UrlShortener.class);
    private String uriRequest;
    private boolean isAvailable = false;

    public UrlShortener() throws Exception {
        this(ScopeProvider.instance.get());
    }

    private UrlShortener(String scope) throws Exception {
        try {
            logger.info("Trying to read the Runtime Resource with name {}, in the scope: {}", (Object)SHORTENER, (Object)scope);
            if (scope == null || scope.isEmpty()) {
                String msg = "Scope is null or empty! You must set the scope into: " + ScopeProvider.instance.getClass();
                throw new Exception(msg);
            }
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URL-Shortener-DL'").setResult("$resource/Profile/AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List endpoints = client.submit((Query)query);
            if (endpoints.size() == 0) {
                this.isAvailable = false;
                logger.warn("Runtime Resource HTTP-URL-Shortener-DL not found");
                throw new Exception("No Runtime Resource with name: HTTP-URL-Shortener-DL is available in the scope: " + scope);
            }
            ServiceEndpoint.AccessPoint shortnerAP = (ServiceEndpoint.AccessPoint)endpoints.get(0);
            if (shortnerAP != null) {
                shortnerServiceUrl = shortnerAP.address();
                Map propertiesMap = shortnerAP.propertyMap();
                if (propertiesMap == null || propertiesMap.size() == 0) {
                    throw new Exception("You need to add the configurations as properties to HTTP-URL-Shortener-DL");
                }
                String encrKey = this.readPropertyValue(propertiesMap, KEY);
                logger.debug("Read property with name {} and value {}", (Object)KEY, (Object)encrKey);
                if (encrKey != null) {
                    decryptedKEY = StringEncrypter.getEncrypter().decrypt(encrKey);
                    logger.debug("Decrypted {}: {}+++MASKED-KEY+++", (Object)KEY, (Object)decryptedKEY.substring(0, decryptedKEY.length() - 10));
                }
                dynamicLink = this.readPropertyValue(propertiesMap, DYNAMIC_LINK);
                logger.debug("Read property with name {} and value {}", (Object)DYNAMIC_LINK, (Object)dynamicLink);
                suffixOption = this.readPropertyValue(propertiesMap, SUFFIX);
                logger.debug("Read property with name {} and value {}", (Object)SUFFIX, (Object)suffixOption);
            }
            if (shortnerServiceUrl == null || decryptedKEY == null) {
                String error = "The access point in the RR: HTTP-URL-Shortener-DL for scope " + scope + " is not available correctly. Impossible to read the service URL or decrypt the password";
                logger.warn(error);
                throw new Exception(error);
            }
            logger.trace("The shortner service URL is: {}", (Object)shortnerServiceUrl);
            String getParam = "";
            if (decryptedKEY != null && !decryptedKEY.isEmpty()) {
                getParam = "?key=" + decryptedKEY;
            }
            this.uriRequest = shortnerServiceUrl + getParam;
            logger.info("HTTP-URL-Shortener found in scope {}, uriRequest: {}... KEY MASKED", (Object)scope, (Object)this.uriRequest.substring(0, this.uriRequest.length() - 10));
            this.isAvailable = true;
        }
        catch (Exception e) {
            logger.error("An error occurred reading Runtime Resource for name: HTTP-URL-Shortener-DL, the scope is: " + scope, (Throwable)e);
            this.isAvailable = false;
            throw new Exception("No HTTP-URL-Shortener-DL available!");
        }
    }

    public String readPropertyValue(Map<String, ServiceEndpoint.Property> propertiesMap, String key) throws Exception {
        ServiceEndpoint.Property theProperty;
        ServiceEndpoint.Property property = theProperty = propertiesMap.get(key) != null ? propertiesMap.get(key) : null;
        if (theProperty == null) {
            throw new Exception("You need to add the " + key + " Property in the " + SHORTENER);
        }
        return theProperty.value();
    }

    public String shorten(String longUrl) throws Exception {
        if (longUrl == null) {
            return longUrl;
        }
        try {
            logger.debug("shorten the input longUrl: " + longUrl);
            URL url = new URL(this.uriRequest);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", APPLICATION_JSON);
            JSONObject jsonObj = new JSONObject();
            String toLongURL = String.format("%s?link=%s", dynamicLink, longUrl);
            jsonObj.put(LONG_DYNAMIC_LINK, (Object)toLongURL);
            JSONObject jsonObjSuffix = null;
            if (suffixOption != null) {
                jsonObjSuffix = new JSONObject(suffixOption);
            } else {
                jsonObjSuffix = new JSONObject();
                jsonObjSuffix.put("option", (Object)"SHORT");
            }
            jsonObj.put(SUFFIX, (Object)jsonObjSuffix);
            logger.debug("Performing POST request to URI: {}+++MASKED-KEY+++", (Object)this.uriRequest.substring(0, this.uriRequest.length() - 10));
            logger.debug("the body contains the JSON request: \n{}", (Object)jsonObj.toString(3));
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(jsonObj.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            JSONTokener tokener = new JSONTokener((Reader)rd);
            JSONObject jsonObject = new JSONObject(tokener);
            logger.debug("response contains the json: " + jsonObject.toString());
            wr.close();
            rd.close();
            return (String)jsonObject.get("shortLink");
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException error in UrlShortener", (Throwable)e);
            return longUrl;
        }
        catch (IOException e) {
            logger.error("IOException error in UrlShortener", (Throwable)e);
            return longUrl;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Deprecated
    public static String getShortnerServerUrl() {
        return shortnerServiceUrl;
    }

    public static String getShortnerServiceUrl() {
        return shortnerServiceUrl;
    }

    public static String getKey() {
        return KEY;
    }

    public static String getParamKeyValue() {
        return decryptedKEY;
    }

    public String getUriRequest() {
        return this.uriRequest;
    }

    public static String getSuffixOption() {
        return suffixOption;
    }

    public static String getDynamicLink() {
        return dynamicLink;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UrlShortener [uriRequest=");
        builder.append(this.uriRequest);
        builder.append(", isAvailable=");
        builder.append(this.isAvailable);
        builder.append("]");
        return builder.toString();
    }
}

