/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.query.AbstractPreparedCqlQuery;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.PreparedCqlQuery;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.ThriftColumnFamilyQueryImpl;
import com.netflix.astyanax.thrift.model.ThriftCqlResultImpl;
import com.netflix.astyanax.thrift.model.ThriftCqlRowsImpl;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;

public abstract class AbstractThriftCqlQuery<K, C>
implements CqlQuery<K, C> {
    boolean useCompression = false;
    ThriftColumnFamilyQueryImpl<K, C> cfQuery;
    String cql;
    ConsistencyLevel cl = ConsistencyLevel.CL_ONE;

    AbstractThriftCqlQuery(ThriftColumnFamilyQueryImpl<K, C> cfQuery, String cql) {
        this.cfQuery = cfQuery;
        this.cql = cql;
        this.cl = cfQuery.consistencyLevel;
    }

    public OperationResult<CqlResult<K, C>> execute() throws ConnectionException {
        return this.cfQuery.keyspace.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<CqlResult<K, C>>(this.cfQuery.keyspace.tracerFactory.newTracer(CassandraOperationType.CQL, this.cfQuery.columnFamily), this.cfQuery.pinnedHost, this.cfQuery.keyspace.getKeyspaceName()){

            @Override
            public CqlResult<K, C> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                org.apache.cassandra.thrift.CqlResult res = AbstractThriftCqlQuery.this.execute_cql_query(client);
                switch (res.getType()) {
                    case ROWS: {
                        return new ThriftCqlResultImpl(new ThriftCqlRowsImpl(res.getRows(), AbstractThriftCqlQuery.this.cfQuery.columnFamily.getKeySerializer(), AbstractThriftCqlQuery.this.cfQuery.columnFamily.getColumnSerializer()));
                    }
                    case INT: {
                        return new ThriftCqlResultImpl(res.getNum());
                    }
                }
                return null;
            }
        }, this.cfQuery.retry);
    }

    public ListenableFuture<OperationResult<CqlResult<K, C>>> executeAsync() throws ConnectionException {
        return this.cfQuery.keyspace.executor.submit(new Callable<OperationResult<CqlResult<K, C>>>(){

            @Override
            public OperationResult<CqlResult<K, C>> call() throws Exception {
                return AbstractThriftCqlQuery.this.execute();
            }
        });
    }

    public CqlQuery<K, C> useCompression() {
        this.useCompression = true;
        return this;
    }

    public PreparedCqlQuery<K, C> asPreparedStatement() {
        return new AbstractPreparedCqlQuery<K, C>(){

            public OperationResult<CqlResult<K, C>> execute() throws ConnectionException {
                return AbstractThriftCqlQuery.this.cfQuery.keyspace.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<CqlResult<K, C>>(AbstractThriftCqlQuery.this.cfQuery.keyspace.tracerFactory.newTracer(CassandraOperationType.CQL, AbstractThriftCqlQuery.this.cfQuery.columnFamily), AbstractThriftCqlQuery.this.cfQuery.pinnedHost, AbstractThriftCqlQuery.this.cfQuery.keyspace.getKeyspaceName()){

                    @Override
                    public CqlResult<K, C> internalExecute(Cassandra.Client client, ConnectionContext state) throws Exception {
                        CqlPreparedResult res;
                        Integer id = (Integer)state.getMetadata(AbstractThriftCqlQuery.this.cql);
                        if (id == null) {
                            res = AbstractThriftCqlQuery.this.prepare_cql_query(client);
                            id = res.getItemId();
                            state.setMetadata(AbstractThriftCqlQuery.this.cql, (Object)id);
                        }
                        res = AbstractThriftCqlQuery.this.execute_prepared_cql_query(client, id, this.getValues());
                        switch (res.getType()) {
                            case ROWS: {
                                return new ThriftCqlResultImpl(new ThriftCqlRowsImpl(res.getRows(), AbstractThriftCqlQuery.this.cfQuery.columnFamily.getKeySerializer(), AbstractThriftCqlQuery.this.cfQuery.columnFamily.getColumnSerializer()));
                            }
                            case INT: {
                                return new ThriftCqlResultImpl(res.getNum());
                            }
                        }
                        return null;
                    }
                }, AbstractThriftCqlQuery.this.cfQuery.retry);
            }

            public ListenableFuture<OperationResult<CqlResult<K, C>>> executeAsync() throws ConnectionException {
                return AbstractThriftCqlQuery.this.cfQuery.executor.submit(new Callable<OperationResult<CqlResult<K, C>>>(){

                    @Override
                    public OperationResult<CqlResult<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }
        };
    }

    public CqlQuery<K, C> withConsistencyLevel(ConsistencyLevel cl) {
        this.cl = cl;
        return this;
    }

    protected abstract CqlPreparedResult prepare_cql_query(Cassandra.Client var1) throws InvalidRequestException, TException;

    protected abstract org.apache.cassandra.thrift.CqlResult execute_prepared_cql_query(Cassandra.Client var1, int var2, List<ByteBuffer> var3) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException;

    protected abstract org.apache.cassandra.thrift.CqlResult execute_cql_query(Cassandra.Client var1) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException;
}

