/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.model.User;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCUmaUtil {
    private static final Logger log = LoggerFactory.getLogger(OIDCUmaUtil.class);
    private static final boolean REFRESH_UMA_TOKEN = false;
    private static final String LOGOUT_URI = "/c/portal/logout";
    private static final boolean FORCE_LOGOUT_ON_INVALID_OIDC = true;
    private static final boolean FORCE_LOGOUT_ON_MISSING_OIDC = true;
    private static final boolean FORCE_LOGOUT_ON_OIDC_REFRESH_ERROR = true;
    private static final int MAX_AUTHORIZATION_RETRY_ATTEMPTS = 4;
    private static final int AUTHORIZATION_RETRY_ATTEMPTS_DELAY = 4000;

    public static void provideConfiguredPortalClientUMATokenInThreadLocal(String infraContext) {
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        String clientId = configuration.getPortalClientId();
        String clientSecret = configuration.getPortalClientSecret();
        OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientId, clientSecret, configuration.getTokenURL(), infraContext);
    }

    public static void provideClientUMATokenInThreadLocal(String clientId, String clientSecret, URL tokenURL, String infraContext) {
        try {
            log.debug("Getting client token from server");
            JWTToken clientToken = OpenIdConnectRESTHelper.queryClientToken((String)clientId, (String)clientSecret, (URL)tokenURL);
            OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientToken.getAccessTokenAsBearer(), tokenURL, infraContext);
        }
        catch (Exception e) {
            log.error("Cannot retrieve client OIDC token", (Throwable)e);
            return;
        }
    }

    public static void provideClientUMATokenInThreadLocal(String clientAuthorizationBearer, URL tokenURL, String infraContext) {
        String encodedContext;
        try {
            encodedContext = URLEncoder.encode(infraContext, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode context", (Throwable)e);
            return;
        }
        log.debug("URL encoded context is: {}", (Object)encodedContext);
        try {
            log.debug("Getting UMA token from server");
            JWTToken umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)tokenURL, (String)clientAuthorizationBearer, (String)encodedContext, null);
            log.debug("Setting token in the UMA JWT provider");
            UmaJWTProvider.instance.set(JWTTokenUtil.getRawContent(umaToken));
        }
        catch (Exception e) {
            log.error("Cannot retrieve client UMA token", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkUMATicketAndProvideInThreadLocal(HttpServletRequest request, HttpServletResponse response, User user, HttpSession session, String scope) {
        if (user == null) {
            log.error("Current user not found, cannot continue");
            return;
        }
        log.debug("Current user is: {} [{}]", (Object)user.getScreenName(), (Object)user.getEmailAddress());
        if (session == null) {
            log.debug("Session is null, cannot continue");
            return;
        }
        String sessionId = session.getId();
        log.debug("Current session ID is {}", (Object)sessionId);
        String urlEncodedScope = null;
        try {
            urlEncodedScope = URLEncoder.encode(scope, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode scope", (Throwable)e);
            return;
        }
        log.debug("URL encoded scope is: {}", (Object)urlEncodedScope);
        JWTToken umaToken = null;
        Map<String, String> map = JWTCacheProxy.getInstance().getMutexFor(user);
        synchronized (map) {
            log.trace("Getting UMA token for user {}, and session {}", (Object)user.getScreenName(), (Object)sessionId);
            umaToken = JWTCacheProxy.getInstance().getUMAToken(user, sessionId);
            if (umaToken != null && !umaToken.isExpired() && umaToken.getAud().contains(urlEncodedScope)) {
                log.trace("Current UMA token is OK {}", (Object)umaToken.getTokenEssentials());
            } else {
                if (umaToken != null && umaToken.getAud().contains(urlEncodedScope) && umaToken.isExpired()) {
                    log.debug("Suitable UMA token found but it is expired.It will be replaced with new one according to settings {}", (Object)umaToken.getTokenEssentials());
                    umaToken = null;
                    log.debug("Removing inactive UMA token from cache proxy if present for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    JWTCacheProxy.getInstance().removeUMAToken(user, sessionId);
                }
                if (umaToken == null || !umaToken.getAud().contains(urlEncodedScope)) {
                    boolean scopeIsChanged = false;
                    if (umaToken == null) {
                        log.debug("Getting new UMA token for scope {}", (Object)urlEncodedScope);
                    } else if (!umaToken.getAud().contains(urlEncodedScope)) {
                        scopeIsChanged = true;
                        log.info("Getting new UMA token for scope {} since it has been issued for another scope {}", (Object)urlEncodedScope, (Object)umaToken.getTokenEssentials());
                    }
                    log.debug("Getting OIDC token from cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    JWTToken authToken = JWTCacheProxy.getInstance().getOIDCToken(user, sessionId);
                    if (authToken == null) {
                        log.debug("OIDC token is null in cache proxy, force redirecting to logut URI");
                        OIDCUmaUtil.forceLogout(response);
                        return;
                    }
                    log.debug("OIDC token is {}", (Object)authToken.getTokenEssentials());
                    LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration(request);
                    boolean isNotAuthorized = false;
                    int authorizationAttempts = 0;
                    do {
                        try {
                            if (isNotAuthorized || scopeIsChanged || authToken.isExpired()) {
                                if (isNotAuthorized) {
                                    log.info("UMA token is not authorized with current OIDC token, refreshing it to be sure that new grants are present. [attempts: {}]", (Object)authorizationAttempts);
                                    isNotAuthorized = false;
                                } else if (scopeIsChanged) {
                                    log.info("Scope is changed, refreshing token to be sure that new grants are present");
                                } else if (authToken.isExpired()) {
                                    log.debug("OIDC token is expired, trying to refresh it {}", (Object)authToken.getTokenEssentials());
                                }
                                try {
                                    authToken = OpenIdConnectRESTHelper.refreshToken((URL)configuration.getTokenURL(), (JWTToken)authToken);
                                }
                                catch (OpenIdConnectRESTHelperException e) {
                                    log.warn("Error refreshing OIDC token, force redirecting to logut URI");
                                    OIDCUmaUtil.forceLogout(response);
                                    return;
                                }
                                log.debug("Setting refreshed OIDC token in cache proxy");
                                JWTCacheProxy.getInstance().setOIDCToken(user, sessionId, authToken);
                            }
                            log.info("Getting UMA token from OIDC endpoint for scope: " + urlEncodedScope);
                            umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)configuration.getTokenURL(), (String)authToken.getAccessTokenAsBearer(), (String)urlEncodedScope, null);
                            log.debug("Got new UMA token {}", (Object)umaToken.getTokenEssentials());
                        }
                        catch (OpenIdConnectRESTHelperException e) {
                            if (e.hasJSONPayload()) {
                                if (OpenIdConnectRESTHelper.isInvalidBearerTokenError((String)e.getResponseString())) {
                                    log.warn("OIDC token is become invalid, forcing redirect to logout URI");
                                    OIDCUmaUtil.forceLogout(response);
                                    return;
                                }
                                if (!OpenIdConnectRESTHelper.isAccessDeniedNotAuthorizedError((String)e.getResponseString())) continue;
                                log.info("UMA token is" + (isNotAuthorized ? " still" : "") + " not authorized with actual OIDC token");
                                isNotAuthorized = true;
                                if (++authorizationAttempts <= 4) {
                                    log.debug("Sleeping 4000 ms and looping refreshing the OIDC");
                                    try {
                                        Thread.sleep(4000L);
                                    }
                                    catch (InterruptedException ie) {
                                        ie.printStackTrace();
                                    }
                                    continue;
                                }
                                log.warn("OIDC token refresh attempts exhausted");
                                return;
                            }
                            log.error("Getting UMA token from server", (Throwable)e);
                            return;
                        }
                    } while (isNotAuthorized);
                }
                log.debug("Setting UMA token in cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                JWTCacheProxy.getInstance().setUMAToken(user, sessionId, umaToken);
            }
        }
        log.trace("Current UMA token in use is: {}", (Object)umaToken.getTokenEssentials());
        log.debug("Setting UMA token with jti {} in UMA JWT provider", (Object)umaToken.getJti());
        UmaJWTProvider.instance.set(umaToken.getRaw());
    }

    protected static void forceLogout(HttpServletResponse response) {
        try {
            if (!response.isCommitted()) {
                response.sendRedirect(LOGOUT_URI);
            } else {
                log.warn("Cannot redirect to logout URI since the response is already commited");
            }
        }
        catch (IOException e) {
            log.error("Cannot redirect to logout URI: /c/portal/logout", (Throwable)e);
        }
    }
}

