/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import org.apache.abdera.ext.history.FeedPagingHelper;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Source;

public class AtomPager {
    private int _elementsPerPage;
    private int _end;
    private int _firstPage = 1;
    private int _lastPage;
    private int _nextPage;
    private int _page;
    private int _previousPage;
    private int _start;
    private int _totalElements;

    public AtomPager(AtomRequestContext atomRequestContext, int totalElements) {
        this(atomRequestContext.getIntParameter("page"), atomRequestContext.getIntParameter("max", SearchContainer.DEFAULT_DELTA), totalElements);
    }

    public AtomPager(int page, int totalElements) {
        this(page, SearchContainer.DEFAULT_DELTA, totalElements);
    }

    public AtomPager(int page, int elementsPerPage, int totalElements) {
        int lastPage = totalElements / elementsPerPage;
        if (totalElements % elementsPerPage > 0) {
            ++lastPage;
        }
        if (lastPage == 0) {
            lastPage = 1;
        }
        this._lastPage = lastPage;
        this._page = page < this._firstPage ? this._firstPage : (page > this._lastPage ? this._lastPage : page);
        this._totalElements = totalElements;
        this._elementsPerPage = elementsPerPage;
        this._start = (this._page - 1) * this._elementsPerPage;
        int end = this._start + this._elementsPerPage;
        if (end > totalElements) {
            end = totalElements;
        }
        this._end = end - 1;
        this._previousPage = this._page - 1;
        int nextPage = this._page + 1;
        if (nextPage > this._lastPage) {
            nextPage = 0;
        }
        this._nextPage = nextPage;
    }

    public int getElementsPerPage() {
        return this._elementsPerPage;
    }

    public int getEnd() {
        return this._end;
    }

    public int getFirstPage() {
        return this._firstPage;
    }

    public int getLastPage() {
        return this._lastPage;
    }

    public int getNextPage() {
        return this._nextPage;
    }

    public int getPage() {
        return this._page;
    }

    public int getPreviousPage() {
        return this._previousPage;
    }

    public int getStart() {
        return this._start;
    }

    public int getTotalElements() {
        return this._totalElements;
    }

    public void setFeedPagingLinks(Feed feed, String url) {
        FeedPagingHelper.setFirst((Source)feed, (String)AtomUtil.setPageInUrl(url, 1));
        FeedPagingHelper.setLast((Source)feed, (String)AtomUtil.setPageInUrl(url, this._lastPage));
        if (this._previousPage != 0) {
            FeedPagingHelper.setPrevious((Source)feed, (String)AtomUtil.setPageInUrl(url, this._previousPage));
        }
        if (this._nextPage != 0) {
            FeedPagingHelper.setNext((Source)feed, (String)AtomUtil.setPageInUrl(url, this._nextPage));
        }
    }
}

