/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.xml;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class StripDoctypeFilter {
    private int[] _buffer;
    private int _bufferLength;
    private boolean _documentStarted;
    private InputStream _inputStream;
    private Reader _reader;
    private boolean entityDeclaration;

    public StripDoctypeFilter(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public StripDoctypeFilter(Reader reader) {
        this._reader = reader;
    }

    public int read() throws IOException {
        if (this._bufferLength > 0) {
            return this.readFromBuffer();
        }
        int c2 = this.readFromSource();
        if (this._documentStarted) {
            return c2;
        }
        if (c2 == 60) {
            int[] buffer = new int[]{this.readFromSource(), this.readFromSource()};
            if (buffer[0] == 63) {
                this.setBuffer(buffer);
                return c2;
            }
            if (buffer[0] == 33 && buffer[1] == 45) {
                this.setBuffer(buffer);
                return c2;
            }
            if (buffer[0] == 33 && buffer[1] == 68) {
                while (true) {
                    int doctypeContent;
                    if ((doctypeContent = this.readFromSource()) == 91) {
                        this.entityDeclaration = true;
                        continue;
                    }
                    if (doctypeContent == 93) {
                        this.entityDeclaration = false;
                        continue;
                    }
                    if (doctypeContent == 62 && !this.entityDeclaration) break;
                }
                this._documentStarted = true;
                return this.readFromSource();
            }
            this.setBuffer(buffer);
            this._documentStarted = true;
        }
        return c2;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int read = 0;
        read = 0;
        while (read < length) {
            int c2 = this.read();
            if (c2 == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            bytes[offset + read] = (byte)(c2 & 0xFF);
            ++read;
        }
        return read;
    }

    public int read(char[] chars, int offset, int length) throws IOException {
        int read = 0;
        read = 0;
        while (read < length) {
            int c2 = this.read();
            if (c2 == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            chars[offset + read] = (char)c2;
            ++read;
        }
        return read;
    }

    protected int readFromBuffer() {
        --this._bufferLength;
        return this._buffer[this._bufferLength];
    }

    protected int readFromSource() throws IOException {
        if (this._inputStream != null) {
            return this._inputStream.read();
        }
        if (this._reader != null) {
            return this._reader.read();
        }
        throw new IllegalStateException("No underlying source available");
    }

    protected void setBuffer(int[] buffer) {
        this._buffer = buffer;
        ArrayUtil.reverse((int[])this._buffer);
        this._bufferLength = this._buffer.length;
    }
}

