/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTTL
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public GetTTL(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(RequestObject myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.bucket);
        }
        long currentTTL = -1L;
        TransportManager tm = null;
        try {
            tm = this.getTransport(myFile);
            currentTTL = tm.getTTL(this.bucket);
        }
        catch (Exception e) {
            tm.close();
            throw new RemoteBackendException(" Error in getTTL operation ", e.getCause());
        }
        return currentTTL + "";
    }

    @Override
    public String initOperation(RequestObject file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.localPath = file.getLocalPath();
        this.remotePath = remotePath;
        return this.getRemoteIdentifier(remotePath, rootArea);
    }

    @Override
    public String initOperation(RequestObject resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

