/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.util.Map;

public class Note
implements WikiPlugin {
    public static final String PROP_NOTE_IMAGE = "notePlugin.imageName";
    public static final String DEFAULT_NOTE_IMAGE = "note.png";

    public String execute(WikiContext context, Map params) throws PluginException {
        String commandline = (String)params.get("_cmdline");
        if (commandline == null || commandline.length() == 0) {
            return "Unable to obtain plugin command line from parameter'_cmdline'";
        }
        String commentImage = this.imageUrl(context);
        String commentText = this.clean(commandline);
        return "<img src='" + commentImage + "' alt=\"Comment: " + commentText + "\" title=\"" + commentText + "\"/>";
    }

    private String imageUrl(WikiContext ctx) {
        WikiEngine engine = ctx.getEngine();
        String commentImage = engine.getWikiProperties().getProperty(PROP_NOTE_IMAGE, DEFAULT_NOTE_IMAGE);
        commentImage = "images/" + commentImage;
        String resource = engine.getTemplateManager().findResource(ctx, engine.getTemplateDir(), commentImage);
        return ctx.getURL(WikiContext.NONE, resource);
    }

    private String clean(String commandline) {
        return TextUtil.replaceEntities(commandline);
    }
}

