/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.PluginManager;
import com.ecyrd.jspwiki.tags.WikiBodyTag;
import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;

public class PluginTag
extends WikiBodyTag {
    private static final long serialVersionUID = 0L;
    private String m_plugin;
    private String m_args;
    private boolean m_evaluated = false;

    public void release() {
        super.release();
        this.m_args = null;
        this.m_plugin = null;
        this.m_evaluated = false;
    }

    public void setPlugin(String p) {
        this.m_plugin = p;
    }

    public void setArgs(String a2) {
        this.m_args = a2;
    }

    public int doWikiStartTag() throws JspException, IOException {
        this.m_evaluated = false;
        return 2;
    }

    private String executePlugin(String plugin, String args, String body) throws PluginException, IOException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        PluginManager pm = engine.getPluginManager();
        this.m_evaluated = true;
        Map argmap = pm.parseArgs(args);
        if (body != null) {
            argmap.put("_body", body);
        }
        String result = pm.execute(this.m_wikiContext, plugin, argmap);
        return result;
    }

    public int doEndTag() throws JspException {
        if (!this.m_evaluated) {
            try {
                this.pageContext.getOut().write(this.executePlugin(this.m_plugin, this.m_args, null));
            }
            catch (Exception e) {
                log.error((Object)"Failed to insert plugin", (Throwable)e);
                throw new JspException("Tag failed, check logs: " + e.getMessage());
            }
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        try {
            BodyContent bc = this.getBodyContent();
            this.getPreviousOut().write(this.executePlugin(this.m_plugin, this.m_args, bc != null ? bc.getString() : null));
        }
        catch (Exception e) {
            log.error((Object)"Failed to insert plugin", (Throwable)e);
            throw new JspException("Tag failed, check logs: " + e.getMessage());
        }
        return 0;
    }
}

