/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.interceptors;

import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.calls.Call;
import org.gcube.common.calls.Interceptor;
import org.gcube.common.calls.Request;
import org.gcube.common.calls.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(AuthorizationInterceptor.class);
    public static final String token_header = "gcube-token";
    public static final String uma_token_header = "Authorization";

    @Override
    public void handleRequest(Request request, Call call) {
        String token = SecurityTokenProvider.instance.get();
        String accessToken = AccessTokenProvider.instance.get();
        if (accessToken != null) {
            try {
                request.addHeader(uma_token_header, "Bearer " + accessToken);
                this.logger.trace("uma token set");
            }
            catch (Exception e) {
                this.logger.error("error parsing uma token", (Throwable)e);
            }
        } else {
            this.logger.warn("uma token is not set");
        }
        if (token == null) {
            this.logger.warn("security token is not set");
        } else {
            request.addHeader(token_header, token);
            this.logger.trace("security token set in the header is  " + token);
        }
    }

    @Override
    public void handleResponse(Response context, Call callContext) {
    }
}

