/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.asset.BookmarksFolderAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.trash.BookmarksBaseTrashHandler;
import com.liferay.portlet.bookmarks.util.BookmarksUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class BookmarksFolderTrashHandler
extends BookmarksBaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        BookmarksFolderLocalServiceUtil.deleteFolder((long)classPK, (boolean)false);
    }

    public String getClassName() {
        return BookmarksFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, folder.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, folder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getAbsolutePath(portletRequest, folder.getParentFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return folder.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return new BookmarksFolderAssetRenderer(folder);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return BookmarksFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return folder.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return folder.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        if (folder.getParentFolderId() > 0L && BookmarksFolderLocalServiceUtil.fetchBookmarksFolder((long)folder.getParentFolderId()) == null) {
            return false;
        }
        return !folder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderLocalServiceUtil.moveFolder((long)classPK, (long)containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderLocalServiceUtil.moveFolderFromTrash((long)userId, (long)classPK, (long)containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        BookmarksFolderLocalServiceUtil.restoreFolderFromTrash((long)userId, (long)classPK);
    }

    protected BookmarksFolder getBookmarksFolder(long classPK) throws PortalException, SystemException {
        return BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return folder.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
    }
}

