/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkConsumer;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkOptimization;
import org.gcube.contentmanagement.blobstorage.service.operation.ChunkProducer;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.FileWriter;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Operation {
    final Logger logger = LoggerFactory.getLogger(Operation.class);
    String[] server;
    String user;
    private String owner;
    String password;
    String bucket;
    String[] dbNames;
    private Monitor monitor;
    private boolean isChunk;
    String backendType;
    protected static TransportManager transport;

    public Operation(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        this.server = server;
        this.user = user;
        this.password = pwd;
        this.bucket = bucket;
        this.monitor = monitor;
        this.isChunk = isChunk;
        this.backendType = backendType;
        this.dbNames = dbs;
    }

    protected int numOfThread(int totChunks) {
        if (totChunks > 1 && totChunks < 10) {
            int returnint = totChunks - 1;
            return returnint;
        }
        if (totChunks > 10) {
            return 10;
        }
        return 1;
    }

    protected int getLengthCurrentChunk(long len, int i, int dimChunk) {
        int lengthCurrentChunk = 0;
        lengthCurrentChunk = (long)((i + 1) * dimChunk) <= len ? dimChunk : (int)(len - (long)(i * dimChunk));
        return lengthCurrentChunk;
    }

    protected int getNumberOfChunks(long len, long dimChunk) {
        if (len < dimChunk) {
            return 1;
        }
        if (len % dimChunk > 0L) {
            long returnint = len / dimChunk + 1L;
            return (int)returnint;
        }
        long returnint = len / dimChunk;
        return (int)returnint;
    }

    public String put(Upload upload, RequestObject resource, boolean isChunk, boolean isBase64, boolean replaceOption, boolean isLock) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put(MyFile, boolean, boolean) - start");
        }
        long len = 1L;
        if (resource.getLocalPath() != null) {
            len = new File(resource.getLocalPath()).length();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("file size: " + len);
        }
        long dimensionChunk = 0L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT is chukn? " + isChunk);
        }
        if (isChunk) {
            ChunkOptimization chunkOptimization = new ChunkOptimization(len);
            dimensionChunk = chunkOptimization.chunkCalculation();
        } else if (len == 0L) {
            dimensionChunk = 1L;
            len = 1L;
        } else {
            dimensionChunk = len;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put(MyFile, boolean, boolean) - encode length: " + len);
        }
        int totChunks = 1;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("len File: " + len + " len chunk: " + dimensionChunk);
        }
        totChunks = this.getNumberOfChunks(len, dimensionChunk);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put(MyFile, boolean, boolean) - number of chunks: " + totChunks);
        }
        int nThreads = 1;
        if (totChunks > 1) {
            nThreads = this.numOfThread(totChunks);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put(MyFile, boolean, boolean) - number of thread: " + nThreads);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("consumer have a bucket name: " + this.bucket);
        }
        if (totChunks > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("THREAD POOL USED");
            }
            ChunkConsumer consumer = new ChunkConsumer(this.monitor, 1, this.server, this.user, this.password, this.dbNames, isChunk, this.bucket, replaceOption);
            Thread producer = new Thread(new ChunkProducer(this.monitor, resource, dimensionChunk, totChunks, nThreads, this.bucket, consumer));
            producer.start();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("put(MyFile, boolean, boolean) - end");
            }
            producer.join();
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NO THREAD POOL USED");
        }
        TransportManager tm = this.getTransport(resource);
        String objectId = tm.uploadManager(upload, resource, this.bucket, this.bucket + "_1", replaceOption);
        return objectId;
    }

    public String get(Download download, RequestObject myFile, boolean isLock) throws IOException, InterruptedException, Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get(String) - start");
        }
        String unlocKey = null;
        TransportManager tm = this.getTransport(myFile);
        long start = System.currentTimeMillis();
        String path = myFile.getLocalPath();
        if (!"mongo".equalsIgnoreCase("mongo")) {
            this.startPThreadChunk(download, myFile, tm, path);
        } else {
            unlocKey = tm.downloadManager(download, myFile, this.bucket, RequestObject.class);
        }
        if (path != null && new File(path).length() > 0L && this.logger.isDebugEnabled()) {
            this.logger.debug("*** Time for downloading: " + (System.currentTimeMillis() - start) + " ms \n\n");
        }
        return unlocKey;
    }

    protected void startPThreadChunk(Download download, RequestObject myFile, TransportManager tm, String path) throws FileNotFoundException, InterruptedException, IOException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        int j = 0;
        RequestObject value = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("localPath: " + path + " bucket: " + this.bucket);
        }
        FileOutputStream out = null;
        if (path != null && !path.isEmpty()) {
            out = new FileOutputStream(new File(path));
        }
        do {
            value = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("get(String) -");
            }
            try {
                value = (RequestObject)tm.get(download);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("get(String) - \n Trovate " + j + " key");
                }
                value = null;
            }
            if (value != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("get(String) - write chunk , author: " + value.getOwner());
                }
                this.monitor.putRequest(value);
                System.gc();
                executor.submit(new FileWriter(this.monitor, out));
            }
            ++j;
        } while (value != null);
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        out.flush();
        ((OutputStream)out).close();
    }

    protected String getRemoteIdentifier(String remotePath, String rootArea) {
        String buck = null;
        boolean isId = ObjectId.isValid((String)remotePath);
        if (!isId) {
            this.bucket = buck = new BucketCoding().bucketFileCoding(remotePath, rootArea);
            return this.bucket;
        }
        this.bucket = remotePath;
        return this.bucket;
    }

    protected String appendFileSeparator(String source) {
        if (source.lastIndexOf("/") != source.length() - 1) {
            source = source + "/";
        }
        return source;
    }

    protected String extractParent(String source) {
        source = source.substring(0, source.length() - 1);
        String parent = source.substring(source.lastIndexOf("/") + 1);
        this.logger.debug("parent folder extracted: " + parent);
        return parent;
    }

    public abstract Object doIt(RequestObject var1) throws RemoteBackendException;

    public abstract String initOperation(RequestObject var1, String var2, String var3, String[] var4, String var5, boolean var6);

    public abstract String initOperation(RequestObject var1, String var2, String var3, String[] var4, String var5);

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String[] getDbNames() {
        return this.dbNames;
    }

    public void setDbNames(String[] dbNames) {
        this.dbNames = dbNames;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public boolean isChunk() {
        return this.isChunk;
    }

    public void setChunk(boolean isChunk) {
        this.isChunk = isChunk;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    protected TransportManager getTransport(RequestObject myFile) {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        transport = tmf.getTransport(transport, this.backendType, myFile.getGcubeMemoryType(), this.dbNames, myFile.getWriteConcern(), myFile.getReadPreference());
        return transport;
    }
}

