/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport;

import com.mongodb.MongoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.RequestObject;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.operation.Copy;
import org.gcube.contentmanagement.blobstorage.service.operation.CopyDir;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.DuplicateFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Link;
import org.gcube.contentmanagement.blobstorage.service.operation.Lock;
import org.gcube.contentmanagement.blobstorage.service.operation.Move;
import org.gcube.contentmanagement.blobstorage.service.operation.MoveDir;
import org.gcube.contentmanagement.blobstorage.service.operation.SoftCopy;
import org.gcube.contentmanagement.blobstorage.service.operation.Unlock;
import org.gcube.contentmanagement.blobstorage.service.operation.Upload;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.LockOperator;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.UnlockOperator;

public abstract class TransportManager {
    protected MemoryType memoryType;

    public abstract String getName();

    public abstract void initBackend(String[] var1, String var2, String var3, MemoryType var4, String[] var5, String var6, String var7);

    public String downloadManager(Download download, RequestObject myFile, String key, Class<? extends Object> type) throws Exception {
        String key4lock = null;
        if (myFile.isLock()) {
            download.setResource(myFile);
            this.get(download);
            LockOperator lock = new LockOperator(download.getServer(), download.getUser(), download.getPassword(), download.getBucket(), download.getMonitor(), download.isChunk(), download.getBackendType(), download.getDbNames());
            lock.setResource(myFile);
            key4lock = this.lock(lock);
            return key4lock;
        }
        return this.get(download).toString();
    }

    public String uploadManager(Upload upload, Object resource, String bucket, String key, boolean replace) throws Exception {
        String id = null;
        RequestObject file = (RequestObject)resource;
        if (file.getLockedKey() != null && !file.getLockedKey().isEmpty()) {
            UnlockOperator unlock = new UnlockOperator(upload.getServer(), upload.getUser(), upload.getPassword(), upload.getBucket(), upload.getMonitor(), upload.isChunk(), upload.getBackendType(), upload.getDbNames());
            unlock.setResource(file);
            unlock.setKeyUnlock(file.getLockedKey());
            id = this.unlock(unlock);
            upload.setResource(file);
            id = this.put(upload);
        } else {
            id = this.put(upload);
        }
        return id;
    }

    public abstract Object get(Download var1) throws FileNotFoundException, IOException;

    public abstract String put(Upload var1) throws FileNotFoundException, IOException;

    public abstract Map<String, StorageObject> getValues(RequestObject var1, String var2, Class<? extends Object> var3);

    public abstract void removeRemoteFile(String var1, RequestObject var2) throws UnknownHostException;

    public abstract void removeDir(String var1, RequestObject var2) throws UnknownHostException;

    public abstract long getSize(String var1, RequestObject var2);

    public abstract String lock(Lock var1) throws Exception;

    public abstract String unlock(Unlock var1) throws FileNotFoundException, UnknownHostException, MongoException, Exception;

    public abstract long getTTL(String var1) throws UnknownHostException;

    public abstract long renewTTL(RequestObject var1) throws UnknownHostException, IllegalAccessException;

    public abstract String link(Link var1) throws UnknownHostException;

    public abstract String copy(Copy var1) throws UnknownHostException;

    public abstract String move(Move var1) throws UnknownHostException;

    public abstract List<String> copyDir(CopyDir var1) throws UnknownHostException;

    public abstract List<String> moveDir(MoveDir var1) throws UnknownHostException;

    public abstract String getFileProperty(String var1, String var2);

    public abstract long getFolderTotalItems(String var1);

    public abstract long getFolderTotalVolume(String var1);

    public abstract String getUserTotalVolume(String var1);

    public abstract String getUserTotalItems(String var1);

    public abstract boolean isValidId(String var1);

    public abstract String getId(String var1, boolean var2);

    public abstract String getField(String var1, String var2) throws UnknownHostException;

    public abstract void close();

    public abstract void setFileProperty(String var1, String var2, String var3);

    public abstract String getRemotePath(String var1) throws UnknownHostException;

    public abstract boolean exist(String var1);

    public abstract String duplicateFile(DuplicateFile var1);

    public String softCopy(SoftCopy copy) throws UnknownHostException {
        return null;
    }
}

