/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.NTripleWriter;
import com.hp.hpl.mesa.rdf.jena.common.RDFXMLWriter;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class testWriterInterface {
    private boolean inError = false;

    protected static void doTest(Model model) {
        new testWriterInterface().test(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void test(Model model) {
        String string = "testWriterInterface";
        String string2 = "modules/rdf/regression/" + string + "/";
        int n = 0;
        File file = null;
        try {
            try {
                RDFWriter rDFWriter;
                block10: {
                    ++n;
                    rDFWriter = model.getWriter();
                    if (!(rDFWriter instanceof RDFXMLWriter)) {
                        this.error(string, n);
                    }
                    ++n;
                    rDFWriter = model.getWriter("RDF/XML");
                    if (!(rDFWriter instanceof RDFXMLWriter)) {
                        this.error(string, n);
                    }
                    ++n;
                    rDFWriter = model.getWriter("N-TRIPLE");
                    if (!(rDFWriter instanceof NTripleWriter)) {
                        this.error(string, n);
                    }
                    ++n;
                    try {
                        model.setWriterClassName("foobar", "");
                        rDFWriter = model.getWriter("foobar");
                        this.error(string, n);
                    }
                    catch (RDFException rDFException) {
                        if (rDFException.getErrorCode() == 21) break block10;
                        this.error(string, n);
                    }
                }
                ++n;
                model.setWriterClassName("foobar", "com.hp.hpl.mesa.rdf.jena.common.RDFXMLWriter");
                rDFWriter = model.getWriter("foobar");
                if (!(rDFWriter instanceof RDFXMLWriter)) {
                    this.error(string, n);
                }
                ++n;
                file = File.createTempFile("~jena", ".rdf");
                model.write(new PrintWriter(new FileWriter(file)));
                ++n;
                model.write(new PrintWriter(new FileWriter(file)), "N-TRIPLE");
                ++n;
                model.write(new PrintWriter(new FileWriter(file)), "N-TRIPLE", "");
            }
            catch (Exception exception) {
                this.inError = true;
                ErrorHelper.logInternalError(" test " + string, n, exception);
                Object var9_10 = null;
                file.delete();
                return;
            }
            Object var9_9 = null;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            file.delete();
            throw throwable;
        }
    }

    protected void error(String string, int n) {
        System.out.println(string + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

