/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.io.delta;

import com.liferay.io.delta.ByteChannelReader;
import com.liferay.io.delta.ByteChannelWriter;
import com.liferay.io.delta.RollingChecksum;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class Differ {
    private Map<Integer, BlockData> _blockDatas;
    private int _blockLength;
    private int _blocksCount;
    private ByteBuffer _checksumsByteBuffer;
    private ByteChannelReader _checksumsByteChannelReader;
    private ByteBuffer _dataByteBuffer;
    private ByteBuffer _deltaByteBuffer;
    private ByteChannelWriter _deltaByteChannelWriter;
    private int _firstBlockNumber;
    private int _lastBlockNumber;
    private ReadableByteChannel _modifiedReadableByteChannel;
    private RollingChecksum _rollingChecksum;

    public void delta(ReadableByteChannel modifiedReadableByteChannel, ByteChannelReader checksumsByteChannelReader, ByteChannelWriter deltaByteChannelWriter) throws IOException {
        this._modifiedReadableByteChannel = modifiedReadableByteChannel;
        this._checksumsByteChannelReader = checksumsByteChannelReader;
        this._deltaByteChannelWriter = deltaByteChannelWriter;
        this._checksumsByteChannelReader.resizeBuffer(320);
        this._checksumsByteBuffer = this._checksumsByteChannelReader.getBuffer();
        this.readChecksumsHeader();
        this.readChecksums();
        this._rollingChecksum = new RollingChecksum(this._modifiedReadableByteChannel, this._blockLength);
        this._deltaByteChannelWriter.resizeBuffer(this._blockLength * 16 + 5);
        this._deltaByteBuffer = this._deltaByteChannelWriter.getBuffer();
        if (this._dataByteBuffer == null || this._dataByteBuffer.capacity() < this._blockLength * 16) {
            this._dataByteBuffer = ByteBuffer.allocate(this._blockLength * 16);
        }
        this.writeDeltaHeader();
        this.writeDeltaBlocks();
    }

    protected void readChecksums() throws IOException {
        this._blockDatas = new HashMap<Integer, BlockData>(this._blocksCount);
        for (int blockNumber = 0; blockNumber < this._blocksCount; ++blockNumber) {
            this._checksumsByteChannelReader.ensureData(20);
            int weakChecksum = this._checksumsByteBuffer.getInt();
            byte[] strongChecksum = new byte[16];
            this._checksumsByteBuffer.get(strongChecksum);
            this._blockDatas.put(weakChecksum, new BlockData(blockNumber, strongChecksum));
        }
    }

    protected void readChecksumsHeader() throws IOException {
        this._checksumsByteChannelReader.ensureData(9);
        if (1 != this._checksumsByteBuffer.get()) {
            throw new IOException("Unknown protocol version");
        }
        this._blockLength = this._checksumsByteBuffer.getInt();
        this._blocksCount = this._checksumsByteBuffer.getInt();
    }

    protected void writeDataBlock() throws IOException {
        if (this._dataByteBuffer.position() == 0) {
            return;
        }
        this._deltaByteChannelWriter.ensureSpace(this._dataByteBuffer.position() + 5);
        this._deltaByteBuffer.put((byte)1);
        this._deltaByteBuffer.putInt(this._dataByteBuffer.position());
        this._dataByteBuffer.flip();
        this._deltaByteBuffer.put(this._dataByteBuffer);
        this._dataByteBuffer.clear();
    }

    protected void writeDeltaBlocks() throws IOException {
        this._firstBlockNumber = -1;
        this._lastBlockNumber = -1;
        while (this._rollingChecksum.hasNext()) {
            BlockData blockData = this._blockDatas.get(this._rollingChecksum.weakChecksum());
            if (blockData != null && MessageDigest.isEqual(blockData.getStrongChecksum(), this._rollingChecksum.strongChecksum())) {
                int blockNumber = blockData.getBlockNumber();
                if (this._firstBlockNumber == -1) {
                    this.writeDataBlock();
                    this._firstBlockNumber = blockNumber;
                    this._lastBlockNumber = blockNumber;
                } else if (this._lastBlockNumber + 1 == blockNumber) {
                    this._lastBlockNumber = blockNumber;
                } else {
                    this.writeReferenceBlock();
                    this._firstBlockNumber = blockNumber;
                    this._lastBlockNumber = blockNumber;
                }
                this._rollingChecksum.nextBlock();
                continue;
            }
            this.writeReferenceBlock();
            if (!this._dataByteBuffer.hasRemaining()) {
                this.writeDataBlock();
            }
            this._dataByteBuffer.put(this._rollingChecksum.getFirstByte());
            this._rollingChecksum.nextByte();
        }
        this.writeReferenceBlock();
        this.writeDataBlock();
        this._deltaByteChannelWriter.ensureSpace(1);
        this._deltaByteBuffer.put((byte)0);
    }

    protected void writeDeltaHeader() throws IOException {
        this._deltaByteChannelWriter.ensureSpace(5);
        this._deltaByteBuffer.put((byte)1);
        this._deltaByteBuffer.putInt(this._blockLength);
    }

    protected void writeReferenceBlock() throws IOException {
        if (this._firstBlockNumber == -1) {
            return;
        }
        if (this._lastBlockNumber == this._firstBlockNumber) {
            this._deltaByteChannelWriter.ensureSpace(5);
            this._deltaByteBuffer.put((byte)2);
            this._deltaByteBuffer.putInt(this._firstBlockNumber);
        } else {
            this._deltaByteChannelWriter.ensureSpace(9);
            this._deltaByteBuffer.put((byte)3);
            this._deltaByteBuffer.putInt(this._firstBlockNumber);
            this._deltaByteBuffer.putInt(this._lastBlockNumber);
        }
        this._firstBlockNumber = -1;
        this._lastBlockNumber = -1;
    }

    private class BlockData {
        private int _blockNumber;
        private byte[] _strongChecksum;

        public BlockData(int blockNumber, byte[] strongChecksum) {
            this._blockNumber = blockNumber;
            this._strongChecksum = strongChecksum;
        }

        public int getBlockNumber() {
            return this._blockNumber;
        }

        public byte[] getStrongChecksum() {
            return this._strongChecksum;
        }
    }
}

