/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class ConstantNode
extends ValueNode {
    DataValueDescriptor value;

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.setType((TypeId)object, (Boolean)object2, (Integer)object3);
    }

    ConstantNode() {
    }

    void setValue(DataValueDescriptor dataValueDescriptor) {
        this.value = dataValueDescriptor;
    }

    public DataValueDescriptor getValue() {
        return this.value;
    }

    public String toString() {
        return "";
    }

    public boolean isCloneable() {
        return true;
    }

    public ValueNode getClone() {
        return this;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        return this;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return true;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isNull()) {
            expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        } else {
            this.generateConstant(expressionClassBuilder, methodBuilder);
            expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
        }
    }

    abstract void generateConstant(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    boolean isNull() {
        return this.value == null || this.value.isNull();
    }

    protected int getOrderableVariantType() {
        return 3;
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeType(valueNode)) {
            ConstantNode constantNode = (ConstantNode)valueNode;
            return constantNode.getValue() == null && this.getValue() == null || constantNode.getValue() != null && constantNode.getValue().compare(this.getValue()) == 0;
        }
        return false;
    }
}

