/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementGenericPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dataDictionary, UUID uUID, String string) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID, null);
        return schemaDescriptor;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dataDictionary, Activation activation, String string) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, false);
        if (schemaDescriptor == null || schemaDescriptor.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction createSchemaConstantAction = new CreateSchemaConstantAction(string, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(string)) {
                    DDLConstantAction.executeCAPreferSubTrans(createSchemaConstantAction, transactionController, activation);
                } else {
                    try {
                        createSchemaConstantAction.executeConstantAction(activation);
                    }
                    catch (StandardException standardException) {
                        if (standardException.getMessageId().equals("X0Y68.S")) break block5;
                        throw standardException;
                    }
                }
            }
            schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        }
        return schemaDescriptor;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction createSchemaConstantAction, TransactionController transactionController, Activation activation) throws StandardException {
        TransactionController transactionController2 = null;
        TransactionController transactionController3 = null;
        try {
            transactionController2 = transactionController3 = transactionController.startNestedUserTransaction(false, true);
        }
        catch (StandardException standardException) {
            transactionController2 = transactionController;
        }
        while (true) {
            try {
                createSchemaConstantAction.executeConstantAction(activation, transactionController2);
            }
            catch (StandardException standardException) {
                if (standardException.isLockTimeout()) {
                    if (!standardException.getMessageId().equals("40XL1.T.1") && transactionController2 == transactionController3) {
                        transactionController2 = transactionController;
                        transactionController3.destroy();
                        continue;
                    }
                } else if (standardException.getMessageId().equals("X0Y68.S")) break;
                if (transactionController2 == transactionController3) {
                    transactionController3.destroy();
                }
                throw standardException;
            }
            break;
        }
        if (transactionController2 == transactionController3) {
            transactionController3.commit();
            transactionController3.destroy();
        }
    }

    final void lockTableForDDL(TransactionController transactionController, long l, boolean bl) throws StandardException {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, bl ? 68 : 64, 7, 5);
        conglomerateController.close();
    }

    protected String constructToString(String string, String string2) {
        return string + string2;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID uUID, ProviderInfo[] providerInfoArray) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        String string = dataDictionary.getAuthorizationDatabaseOwner();
        String string2 = languageConnectionContext.getCurrentUserId(activation);
        SettableBoolean settableBoolean = new SettableBoolean();
        if (!string2.equals(dataDictionary.getAuthorizationDatabaseOwner()) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementPermission statementPermission;
                StatementPermission statementPermission2 = (StatementPermission)iterator.next();
                if (!(statementPermission2 instanceof StatementTablePermission) ? statementPermission2 instanceof StatementSchemaPermission || statementPermission2 instanceof StatementRolePermission || statementPermission2 instanceof StatementGenericPermission || !this.inProviderSet(providerInfoArray, ((StatementRoutinePermission)(statementPermission = (StatementRoutinePermission)statementPermission2)).getRoutineUUID()) : ((StatementTablePermission)(statementPermission = (StatementTablePermission)statementPermission2)).getPrivType() != 2 || !((StatementTablePermission)statementPermission).getTableUUID().equals(uUID)) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission2.getPermissionDescriptor(string2, dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission2.getPermissionDescriptor("PUBLIC", dataDictionary);
                    boolean bl = false;
                    if (permissionsDescriptor == null || permissionsDescriptor instanceof ColPermsDescriptor && !((StatementColumnPermission)statementPermission2).allColumnsCoveredByUserOrPUBLIC(string2, dataDictionary)) {
                        bl = true;
                        permissionsDescriptor = DDLConstantAction.findRoleUsage(activation, statementPermission2);
                    }
                    if (!permissionsDescriptor.checkOwner(string2)) {
                        dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                        if (bl) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                        }
                    }
                } else if (!permissionsDescriptor.checkOwner(string2)) {
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    if (permissionsDescriptor instanceof ColPermsDescriptor) {
                        statementPermission = (StatementColumnPermission)statementPermission2;
                        permissionsDescriptor = ((StatementColumnPermission)statementPermission).getPUBLIClevelColPermsDescriptor(string2, dataDictionary);
                        if (permissionsDescriptor != null && permissionsDescriptor.getObjectID() != null) {
                            dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                        }
                        if (!((StatementColumnPermission)statementPermission).allColumnsCoveredByUserOrPUBLIC(string2, dataDictionary)) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                        }
                    }
                }
                if (statementPermission2 instanceof StatementRoutinePermission) continue;
                break;
            }
        }
    }

    private static PermissionsDescriptor findRoleUsage(Activation activation, StatementPermission statementPermission) throws StandardException {
        String string;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        RoleGrantDescriptor roleGrantDescriptor = null;
        String string2 = languageConnectionContext.getCurrentRoleId(activation);
        String string3 = dataDictionary.getAuthorizationDatabaseOwner();
        String string4 = languageConnectionContext.getCurrentUserId(activation);
        PermissionsDescriptor permissionsDescriptor = null;
        roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string4, string3);
        if (roleGrantDescriptor == null) {
            roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", string3);
        }
        RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
        while (permissionsDescriptor == null && (string = roleClosureIterator.next()) != null) {
            permissionsDescriptor = statementPermission.getPermissionDescriptor(string, dataDictionary);
        }
        return permissionsDescriptor;
    }

    private static void trackRoleDependency(Activation activation, Dependent dependent, SettableBoolean settableBoolean) throws StandardException {
        if (!settableBoolean.get()) {
            LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            String string = languageConnectionContext.getCurrentRoleId(activation);
            RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string);
            dependencyManager.addDependency(dependent, roleGrantDescriptor, languageConnectionContext.getContextManager());
            settableBoolean.set(true);
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        String string = dataDictionary.getAuthorizationDatabaseOwner();
        String string2 = languageConnectionContext.getCurrentUserId(activation);
        SettableBoolean settableBoolean = new SettableBoolean();
        if (!string2.equals(string) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementPermission statementPermission = (StatementPermission)iterator.next();
                if (statementPermission instanceof StatementSchemaPermission || statementPermission instanceof StatementRolePermission) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission.getPermissionDescriptor(string2, dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission.getPermissionDescriptor("PUBLIC", dataDictionary);
                    boolean bl = false;
                    if (permissionsDescriptor == null || permissionsDescriptor instanceof ColPermsDescriptor && !((StatementColumnPermission)statementPermission).allColumnsCoveredByUserOrPUBLIC(string2, dataDictionary)) {
                        bl = true;
                        permissionsDescriptor = DDLConstantAction.findRoleUsage(activation, statementPermission);
                    }
                    if (permissionsDescriptor.checkOwner(string2)) continue;
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    if (!bl) continue;
                    DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                    continue;
                }
                if (permissionsDescriptor.checkOwner(string2)) continue;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                if (!(permissionsDescriptor instanceof ColPermsDescriptor)) continue;
                StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statementPermission;
                permissionsDescriptor = statementColumnPermission.getPUBLIClevelColPermsDescriptor(string2, dataDictionary);
                if (permissionsDescriptor != null && permissionsDescriptor.getObjectID() != null) {
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                }
                if (statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(string2, dataDictionary)) continue;
                DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
            }
        }
    }

    private boolean inProviderSet(ProviderInfo[] providerInfoArray, UUID uUID) {
        if (providerInfoArray == null) {
            return false;
        }
        for (int i = 0; i < providerInfoArray.length; ++i) {
            if (!providerInfoArray[i].getObjectId().equals(uUID)) continue;
            return true;
        }
        return false;
    }

    protected void addColumnDependencies(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, TableDescriptor tableDescriptor, ColumnInfo columnInfo) throws StandardException {
        ProviderInfo[] providerInfoArray = columnInfo.providers;
        if (providerInfoArray != null) {
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            ContextManager contextManager = languageConnectionContext.getContextManager();
            int n = providerInfoArray.length;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(columnInfo.name);
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
            for (int i = 0; i < n; ++i) {
                ProviderInfo providerInfo = providerInfoArray[i];
                DependableFinder dependableFinder = providerInfo.getDependableFinder();
                UUID uUID = providerInfo.getObjectId();
                Provider provider = (Provider)dependableFinder.getDependable(dataDictionary, uUID);
                dependencyManager.addDependency(defaultDescriptor, provider, contextManager);
            }
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, TableDescriptor tableDescriptor, ColumnInfo[] columnInfoArray, boolean bl) throws StandardException {
        Object object;
        if (!bl && columnInfoArray == null) {
            return;
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        int n = columnInfoArray == null ? 0 : columnInfoArray.length;
        HashMap<Object, AliasDescriptor> hashMap = new HashMap<Object, AliasDescriptor>();
        HashMap<Object, AliasDescriptor> hashMap2 = new HashMap<Object, AliasDescriptor>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = columnInfoArray[i];
            AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptorForUDT(transactionController, columnInfoArray[i].dataType);
            if (aliasDescriptor == null) continue;
            object = aliasDescriptor.getObjectID().toString();
            if (columnInfo.action == 0) {
                hashSet.add(columnInfo.name);
                if (hashMap.get(object) != null) continue;
                hashMap.put(object, aliasDescriptor);
                continue;
            }
            if (columnInfo.action != 1) continue;
            hashSet2.add(columnInfo.name);
            hashMap2.put(object, aliasDescriptor);
        }
        if (!bl && hashMap.size() == 0 && hashMap2.size() == 0) {
            return;
        }
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int i = 0; i < n2; ++i) {
            AliasDescriptor aliasDescriptor;
            object = columnDescriptorList.elementAt(i);
            if (hashSet.contains(((ColumnDescriptor)object).getColumnName()) || hashSet2.contains(((ColumnDescriptor)object).getColumnName()) || (aliasDescriptor = dataDictionary.getAliasDescriptorForUDT(transactionController, ((ColumnDescriptor)object).getType())) == null) continue;
            String string = aliasDescriptor.getObjectID().toString();
            if (bl) {
                hashMap2.put(string, aliasDescriptor);
                continue;
            }
            if (hashMap.get(string) != null) {
                hashMap.remove(string);
            }
            if (hashMap2.get(string) == null) continue;
            hashMap2.remove(string);
        }
        this.adjustUDTDependencies(languageConnectionContext, dataDictionary, (Dependent)tableDescriptor, hashMap, hashMap2);
    }

    private void adjustUDTDependencies(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, Dependent dependent, HashMap hashMap, HashMap hashMap2) throws StandardException {
        Object object;
        if (hashMap.size() == 0 && hashMap2.size() == 0) {
            return;
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        ContextManager contextManager = languageConnectionContext.getContextManager();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (AliasDescriptor)iterator.next();
            dependencyManager.addDependency(dependent, (Provider)object, contextManager);
        }
        object = hashMap2.values().iterator();
        while (object.hasNext()) {
            AliasDescriptor aliasDescriptor = (AliasDescriptor)object.next();
            DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(dependent, aliasDescriptor);
            dataDictionary.dropStoredDependency(dependencyDescriptor, transactionController);
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, AliasDescriptor aliasDescriptor, boolean bl) throws StandardException {
        TypeDescriptor[] typeDescriptorArray;
        AliasDescriptor aliasDescriptor2;
        int n;
        int n2;
        TypeDescriptor[] typeDescriptorArray2;
        TypeDescriptor typeDescriptor;
        RoutineAliasInfo routineAliasInfo = null;
        AggregateAliasInfo aggregateAliasInfo = null;
        switch (aliasDescriptor.getAliasType()) {
            case 'G': {
                aggregateAliasInfo = (AggregateAliasInfo)aliasDescriptor.getAliasInfo();
                break;
            }
            case 'F': 
            case 'P': {
                routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                break;
            }
            default: {
                return;
            }
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap hashMap2 = new HashMap();
        HashMap<String, Object> hashMap3 = bl ? hashMap : hashMap2;
        TypeDescriptor typeDescriptor2 = typeDescriptor = aggregateAliasInfo != null ? aggregateAliasInfo.getReturnType() : routineAliasInfo.getReturnType();
        if (typeDescriptor != null && (typeDescriptorArray2 = dataDictionary.getAliasDescriptorForUDT(transactionController, DataTypeDescriptor.getType(typeDescriptor))) != null) {
            hashMap3.put(typeDescriptorArray2.getObjectID().toString(), typeDescriptorArray2);
        }
        if (typeDescriptor != null && typeDescriptor.isRowMultiSet()) {
            typeDescriptorArray2 = typeDescriptor.getRowTypes();
            n2 = typeDescriptorArray2.length;
            for (n = 0; n < n2; ++n) {
                aliasDescriptor2 = dataDictionary.getAliasDescriptorForUDT(transactionController, DataTypeDescriptor.getType(typeDescriptorArray2[n]));
                if (aliasDescriptor2 == null) continue;
                hashMap3.put(aliasDescriptor2.getObjectID().toString(), aliasDescriptor2);
            }
        }
        if (aggregateAliasInfo != null) {
            TypeDescriptor[] typeDescriptorArray3 = new TypeDescriptor[1];
            typeDescriptorArray = typeDescriptorArray3;
            typeDescriptorArray3[0] = aggregateAliasInfo.getForType();
        } else {
            typeDescriptorArray = typeDescriptorArray2 = routineAliasInfo.getParameterTypes();
        }
        if (typeDescriptorArray2 != null) {
            n2 = typeDescriptorArray2.length;
            for (n = 0; n < n2; ++n) {
                aliasDescriptor2 = dataDictionary.getAliasDescriptorForUDT(transactionController, DataTypeDescriptor.getType(typeDescriptorArray2[n]));
                if (aliasDescriptor2 == null) continue;
                hashMap3.put(aliasDescriptor2.getObjectID().toString(), aliasDescriptor2);
            }
        }
        this.adjustUDTDependencies(languageConnectionContext, dataDictionary, aliasDescriptor, hashMap, hashMap2);
    }

    private class SettableBoolean {
        boolean value = false;

        SettableBoolean() {
        }

        void set(boolean bl) {
            this.value = bl;
        }

        boolean get() {
            return this.value;
        }
    }
}

