/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class IndexExpression {
    public final ByteBuffer column;
    public final Operator operator;
    public final ByteBuffer value;

    public IndexExpression(ByteBuffer column, Operator operator, ByteBuffer value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public boolean isContains() {
        return Operator.CONTAINS == this.operator;
    }

    public boolean isContainsKey() {
        return Operator.CONTAINS_KEY == this.operator;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{ByteBufferUtil.bytesToHex(this.column), this.operator, ByteBufferUtil.bytesToHex(this.value)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexExpression)) {
            return false;
        }
        IndexExpression ie = (IndexExpression)o;
        return Objects.equal((Object)this.column, (Object)ie.column) && Objects.equal((Object)((Object)this.operator), (Object)((Object)ie.operator)) && Objects.equal((Object)this.value, (Object)ie.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.column, this.operator, this.value});
    }

    public void writeTo(DataOutputPlus output) throws IOException {
        ByteBufferUtil.writeWithShortLength(this.column, output);
        this.operator.writeTo(output);
        ByteBufferUtil.writeWithShortLength(this.value, output);
    }

    public static IndexExpression readFrom(DataInput input) throws IOException {
        return new IndexExpression(ByteBufferUtil.readWithShortLength(input), Operator.readFrom(input), ByteBufferUtil.readWithShortLength(input));
    }
}

